% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UCS3functions.R
\name{fitted.UComp}
\alias{fitted.UComp}
\title{fitted.UComp}
\usage{
\method{fitted}{UComp}(object, ...)
}
\arguments{
\item{object}{Object of class \dQuote{UComp}.}

\item{...}{Additional inputs to function.}
}
\description{
Fitted output values of UComp object
}
\details{
#' @title autoplot.UComp
#' @description Plot components of UComp object
#'
#' @details See help of \code{UC}.
#'
#' @author Diego J. Pedregal
#' 
#' @seealso \code{\link{UC}}, \code{\link{UCmodel}}, \code{\link{UCvalidate}}, \code{\link{UCfilter}}, \code{\link{UCsmooth}}, 
#'          \code{\link{UCdisturb}}, \code{\link{UCcomponents}}
#'          
#' @examples
#' y <- log(AirPassengers)
#' m1 <- UCmodel(y)
#' autoplot(m1)
#' @rdname autoplot.UComp
#' @export
autoplot.UComp = function(comp){
    # Smoothing if necessary
    if (any(class(comp) == "UComp")){
        if (length(comp$comp) < 2){
            comp = UCcomponents(comp)
        }
        comp = comp$comp
    }
    autoplot(comp[, colnames(comp)], facets = TRUE) +
        xlab("") + ylab("") +
        ggtitle("Time Series Components")
}

See help of \code{UC}.
}
\examples{
y <- log(AirPassengers)
m1 <- UCmodel(y, model = "llt/equal/arma(0,0)")
fitted(m1)
}
\seealso{
\code{\link{UC}}, \code{\link{UCmodel}}, \code{\link{UCvalidate}}, \code{\link{UCfilter}}, \code{\link{UCsmooth}}, 
         \code{\link{UCdisturb}}, \code{\link{UCcomponents}}
}
\author{
Diego J. Pedregal
}
