% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ARIMAS3functions.R, R/ETSS3functions.R,
%   R/PTSS3functions.R, R/TETSS3functions.R
\name{print.ARIMA}
\alias{print.ARIMA}
\alias{print.ETS}
\alias{print.PTS}
\alias{print.TETS}
\title{print.ARIMA}
\usage{
\method{print}{ARIMA}(x, ...)

\method{print}{ETS}(x, ...)

\method{print}{PTS}(x, ...)

\method{print}{TETS}(x, ...)
}
\arguments{
\item{x}{Object of class \dQuote{TETS}.}

\item{...}{Additional inputs to handle the way to print output.}
}
\description{
Prints an ARIMA object

Prints an ETS object

Prints a PTS object

Prints a TOBIT TETS object
}
\details{
See help of \code{ARIMA}.

See help of \code{ETS}.

See help of \code{PTS}.

See help of \code{TETS}.
}
\examples{
\dontrun{
m1 <- ARIMAmodel(log(gdp))
print(m1)
}
\dontrun{
m1 <- ETSmodel(log(gdp))
print(m1)
}
\dontrun{
m1 <- PTSmodel(log(AirPassengers))
print(m1)
}
\dontrun{
m1 <- TETSmodel(log(gdp))
print(m1)
}
}
\seealso{
\code{\link{ARIMA}}, \code{\link{ARIMAmodel}}, \code{\link{ARIMAvalidate}},

\code{\link{ETS}}, \code{\link{ETSmodel}}, \code{\link{ETSvalidate}},
         \code{\link{ETScomponents}}, \code{\link{ETSestim}}

\code{\link{PTS}}, \code{\link{PTSmodel}}, \code{\link{PTSvalidate}},
         \code{\link{PTScomponents}}, \code{\link{PTSestim}}

\code{\link{TETS}}, \code{\link{TETSmodel}}, \code{\link{TETSvalidate}},
         \code{\link{TETScomponents}}, \code{\link{TETSestim}}
}
\author{
Diego J. Pedregal
}
