% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/All.R
\name{HydroPlot}
\alias{HydroPlot}
\title{Hydrological plot of concurrent discharge and precipitation}
\usage{
HydroPlot(
  x,
  main = "Concurrent Rainfall & Discharge",
  ylab = "Discharge (m3/s)",
  from = NULL,
  to = NULL,
  adj.y = 1.5,
  plw = 1,
  qlw = 1.8,
  Return = FALSE
)
}
\arguments{
\item{x}{a data.frame with three columns in the order of date (or POSIXct), precipitation, and discharge}

\item{main}{a character string. The user chosen plot title. The default is "Concurrent Rainfall & Discharge"}

\item{ylab}{User choice for the y label of the plot. THe default is "Discharge (m3/s)".}

\item{from}{a starting time for the plot. In the form of a date or POSIXct object. The default is the first row of x}

\item{to}{an end time for the plot. In the form of a date or POSIXct object. The default is the last row of x}

\item{adj.y}{a numeric value to adjust the closeness of the preciptation and discharge in the plot. Default is 1.5. A lower value brings them closer and a larger value further apart}

\item{plw}{a numeric value to adjust the width of the precipitation lines. Default is one. A larger value thickens them and vice versa}

\item{qlw}{a numeric value to adjust the width of the discharge line. Default is 1.8. A larger value thickens them and vice versa}

\item{Return}{a logical argument with a default of FALSE. If TRUE the data-frame of time, precipitation, and flow is returned}
}
\value{
A plot of concurrent precipitation and discharge. With the former at the top and the latter at the bottom. If the Return argument equals true the associated data-frame is also returned.
}
\description{
Plots concurrent precipitation and discharge with precipitation along the top and discharge along the bottom
}
\details{
The input of x is a dataframe with the first column being time. If the data is sub daily this should be class POSIXct with time as well as date.
}
\examples{
#Plot the Thames precipitation and discharge for the 2013 hydrological year,
#adjusting the y axis to 1.8.
HydroPlot(ThamesPQ, from = "2013-10-01", to = "2014-09-30", adj.y = 1.8)
}
\author{
Anthony Hammond
}
