% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Extractors.R
\docType{methods}
\name{AIC}
\alias{AIC}
\alias{AIC,VSLCMresults-method}
\title{AIC criterion.}
\usage{
\S4method{AIC}{VSLCMresults}(object)
}
\arguments{
\item{object}{instance of \code{\linkS4class{VSLCMresults}}.}
}
\description{
This function gives the AIC criterion of an instance of \code{\linkS4class{VSLCMresults}}. 
AIC is computed according to the formula\deqn{AIC=log-likelihood - \nu} where  \eqn{\nu} denotes the number of parameters in the fitted model.
}
\examples{
# Data loading:
data(heart)

# Cluster analysis without variable selection
res <- VarSelCluster(heart[,-13], 2, vbleSelec = FALSE)

# Get the AIC value
AIC(res)
}
\references{
Akaike, H. (1974), "A new look at the statistical model identification", IEEE Transactions on Automatic Control, 19 (6): 716-723.
}
