% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_population_radius.R
\name{get_population_radius}
\alias{get_population_radius}
\title{Get population counts within a radius of sampling sites}
\usage{
get_population_radius(lon, lat, radius, path_pop_raster, path_output)
}
\arguments{
\item{lon}{A numeric vector giving the longitudes of the sampling sites in Decimal Degrees.}

\item{lat}{A numeric vector giving the latitudes of the sampling sites in Decimal Degrees.}

\item{radius}{Numeric giving the radius (in meters) around each point to calculate total population}

\item{path_pop_raster}{The file path to a raster object providing population counts in each grid cell.
See \code{download_worldpop_data} for methods to download population raster data.}

\item{path_output}{The file path of an output directory where spatial data will be saved.}
}
\value{
A \code{data.frame} containing the total population counts for the given radius around each sampling site.
}
\description{
This function takes vectors of sampling site longitude and latitude and calculates the total population
residing within a given radius around each sampling site. Intermediate spatial variables are written to
the directory specified in \code{path_output}.
}
\examples{
\donttest{

download_worldpop_data(iso3 = 'MCO',
                       year = 2020,
                       constrained = TRUE,
                       UN_adjusted = FALSE,
                       path_output = tempdir())

get_population_radius(lon = c(7.416, 7.434),
                      lat = c(43.734, 43.747),
                      radius = 100,
                      path_pop_raster = file.path(tempdir(), 'mco_ppp_2020_constrained.tif'),
                      path_output = tempdir())

}
}
