% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getwts.R
\name{getwts}
\alias{getwts}
\alias{getwts.default}
\title{Get weights for regression}
\usage{
getwts(dat_in, ...)

\method{getwts}{default}(dat_in, ref_in, wt_vars = c("day_num",
  "dec_time", "flo"), wins = list(0.5, 10, NULL), all = FALSE,
  slice = TRUE, ngrzero = FALSE, wins_only = FALSE, min_obs = 100,
  ...)
}
\arguments{
\item{dat_in}{input tidal object}

\item{...}{arguments passed to or from other methods}

\item{ref_in}{row of tidal object as reference for weights}

\item{wt_vars}{chr string of three elements indicating names of columns in tidal object that are used for reference row weights}

\item{wins}{list of half-window widths for time, year, and flow}

\item{all}{logical to return individual weights rather than the product of all three, default \code{FALSE}}

\item{slice}{logical indicating if data are subset by observations within the maximum window width for faster calculations}

\item{ngrzero}{logical indicating if count of observations with weights greater than zero is returned}

\item{wins_only}{logical if the half-window widths should be returned as a list}

\item{min_obs}{numeric vector for window widening if the number of observations with non-zero weights is less than the specified value, use \code{min_obs = NULL} to suppress this behavior}
}
\value{
A vector of weights with length equal to the number of observations (rows) in the tidal object.  Vectors for all three weighting variables are returned if \code{all = TRUE}.
}
\description{
Get weights for WRTDS for a single observation using a tri-cubic weighting function
}
\details{
The default half-window widths for \code{day_num}, \code{year}, and \code{flow} are half a day (12 hours), 10 years, and half the range of salinity/flow in the input data.  The half-window widths are expanded by 10\% until at least 100 observations have weights greater than zero.  This behavior can be suppressed by setting \code{min_obs = NULL}.
}
\examples{
##
data(tidobj)

# get weights for first row
first <- tidobj[1, ]
wts <- getwts(tidobj, first)

plot(wts, type = 'l')

\dontrun{

# get count of observations with grzero weights
sapply(1:nrow(tidobj), function(row) getwts(tidobj, tidobj[row, ], 
 ngrzero = TRUE))
}
}
