% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multimarginal_LP.R
\name{multi_marginal}
\alias{multi_marginal}
\title{Solve the multimarginal optimal transport problem by linear programming}
\usage{
multi_marginal(weights, costA)
}
\arguments{
\item{weights}{A list of vectors specifying the weights of the marginal distributions. These vectors do not need to be of the same size.}

\item{costA}{An array where the entry (i1,i2,...,iN) specifies the value of the cost functional for the point i1 in the first measure, i2 in the second measure
and so on.}
}
\value{
A list with two entries. The first entry contains the optimal multicoupling in array form, and the second entry contains 
the cost of the optimal solution.
}
\description{
Solves the N-fold multimarginal optimal transport problem between N specified measures and a specified cost.  This is essentially a convenient wrapper function that builds and solves the corresponding linear program.
}
\examples{
W<-list(rep(1,10),rep(1,10),rep(1,10))
C<-array(runif(10^3),c(10,10,10))
MM<-multi_marginal(W,C)
}
