% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimulateAESString.R
\name{simulate_aes_string}
\alias{simulate_aes_string}
\title{Simulate the deprecated \code{ggplot2::aes_string()}.}
\usage{
simulate_aes_string(...)
}
\arguments{
\item{...}{named string arguments to turn into symbols using `rlang::data_sym()`.}
}
\value{
some rlang NSE that simulates string values at great complexity (but needed for newer ggplot2()).
}
\description{
Use to allow replacing code of the form \code{ggplot2::aes_string(...)}
with code of the form \code{ggplot2::aes(!!!simulate_aes_string(...))}.
Purpose is to get out of the way of the deprecation and possible future removal of \code{ggplot2::aes_string()}.
Inspired by the research of \url{https://stackoverflow.com/a/74424353/6901725}.
}
\examples{

if (requireNamespace('data.table', quietly = TRUE)) {
	# don't multi-thread during CRAN checks
		data.table::setDTthreads(1)
}

d <- data.frame(x = c(1, 2, 3), y = c(4, 5, 6))
xvar <- 'x'  # the idea is, this is passed in and not known at coding time
yvar <- 'y'
# what we want:
#  ggplot2::ggplot(data = d, mapping = ggplot2::aes_string(x = xvar, y = yvar)) +
#     ggplot2::geom_point()
# The required "tidy evaluation ideoms[sic] with `aes()`".
ggplot2::ggplot(data = d, mapping = ggplot2::aes(!!!simulate_aes_string(x = xvar, y = yvar))) +
   ggplot2::geom_point()

}
