library(testthat)
#filePathOutcomes <- file.path(base::path.package("Wats"), "extdata", "BirthRatesOk.txt")
# filePathOutcomes <- file.path(devtools::inst(name="Wats"), "extdata", "BirthRatesOk.txt") #This approach accounts for working on developmental box.
# filePathOutcomes <- file.path(devtools::inst(name="Wats"), "extdata", "BirthRatesOk.txt") #This approach accounts for working on developmental box.


###########
context("Annotate")
###########
test_that("AnnotateDataWithMonthResolution-Median", {
  dsLinear <- CountyMonthBirthRate2005Version
  dsLinear <- dsLinear[dsLinear$CountyName=="oklahoma", ]
  dsLinear <- AugmentYearDataWithMonthResolution(dsLinear=dsLinear, dateName="Date")
  
  hSpread <- function( scores ) { return( quantile(x=scores, probs=c(.25, .75)) ) }
  portfolio <- AnnotateData(dsLinear, dvName="BirthRate", centerFunction=median, spreadFunction=hSpread)
  
  #   head(portfolio$dsStageCycle); dput(portfolio$dsStageCycle)
  #   head(portfolio$dsLinear); dput(head(portfolio$dsLinear))
  #   head(portfolio$dsPeriodic); dput(head(portfolio$dsPeriodic))
  
  expectedStageCycle <- structure(list(StageID = c(1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 
                                                   1L, 1L, 1L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L), 
                                       ProportionID = c(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 1, 
                                                        2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12), ProportionThroughCycle = c(0.0416666666666667, 
                                                                                                                        0.125, 0.208333333333333, 0.291666666666667, 0.375, 0.458333333333333, 
                                                                                                                        0.541666666666667, 0.625, 0.708333333333333, 0.791666666666667, 
                                                                                                                        0.875, 0.958333333333333, 0.0416666666666667, 0.125, 0.208333333333333, 
                                                                                                                        0.291666666666667, 0.375, 0.458333333333333, 0.541666666666667, 
                                                                                                                        0.625, 0.708333333333333, 0.791666666666667, 0.875, 0.958333333333333
                                                        ), PositionLower = c(66.8200512192968, 68.93747306314, 66.1307556378172, 
                                                                             67.7190997634877, 67.65718575015, 70.8841392442781, 70.4065396517016, 
                                                                             71.169050712871, 71.7762980240982, 68.4803530202624, 67.0393597407677, 
                                                                             66.1307556378172, 70.756002768221, 69.3484622905977, 70.7014853956519, 
                                                                             71.1377032236438, 69.5637168412724, 70.9318607184759, 75.883451769697, 
                                                                             75.6073730916667, 79.9076880458871, 74.7234369734118, 69.2063802447064, 
                                                                             72.3861735833143), PositionCenter = c(70.1393031508338, 69.5378223100225, 
                                                                                                                   69.7001229118945, 69.3014740115835, 68.5874728990086, 71.1302540179153, 
                                                                                                                   70.756002768221, 72.935008082989, 72.10866063281, 70.2749207470592, 
                                                                                                                   68.6962260461478, 66.6857852934657, 73.5105943925503, 71.9644403518153, 
                                                                                                                   71.1260225386533, 72.490548820232, 69.9885919018723, 73.7517924651284, 
                                                                                                                   77.498585251654, 77.5237037931476, 81.5518092258413, 75.8760175825285, 
                                                                                                                   71.8400236512282, 74.6206537038472), PositionUpper = c(70.5504362290919, 
                                                                                                                                                                          71.7297748904155, 69.9197130313642, 71.5691169897759, 70.5504362290919, 
                                                                                                                                                                          72.8871026314319, 73.6339343160277, 74.9701168203666, 73.1851290574892, 
                                                                                                                                                                          72.1127419264727, 69.0148541817979, 69.1725209013298, 73.5928210082019, 
                                                                                                                                                                          74.1493189962727, 72.5444316586437, 73.4544062051884, 70.4888225869529, 
                                                                                                                                                                          77.0017994487588, 78.81421110208, 78.6257657212784, 82.9282827718495, 
                                                                                                                                                                          76.5653694836079, 72.3285867925582, 76.5529791716603)), .Names = c("StageID", 
                                                                                                                                                                                                                                             "ProportionID", "ProportionThroughCycle", "PositionLower", "PositionCenter", 
                                                                                                                                                                                                                                             "PositionUpper"), row.names = c(NA, -24L), class = "data.frame")
  expectedLinearHead <- structure(list(Fips = c(40109L, 40109L, 40109L, 40109L, 40109L, 
                                                40109L), CountyName = c("oklahoma", "oklahoma", "oklahoma", "oklahoma", 
                                                                        "oklahoma", "oklahoma"), Year = c(1990L, 1990L, 1990L, 1990L, 
                                                                                                          1990L, 1990L), Month = 1:6, FecundPopulation = c(143192, 143278.666666667, 
                                                                                                                                                           143365.333333333, 143452, 143538.666666667, 143625.333333333), 
                                       BirthCount = c(853L, 758L, 886L, 871L, 822L, 834L), Date = structure(c(7319, 
                                                                                                              7350, 7378, 7409, 7439, 7470), class = "Date"), DaysInMonth = c(31L, 
                                                                                                                                                                              28L, 31L, 30L, 31L, 30L), DaysInYear = c(365L, 365L, 365L, 
                                                                                                                                                                                                                       365L, 365L, 365L), StageID = c(1L, 1L, 1L, 1L, 1L, 1L), BirthRateMonthly = c(5.95703670596123, 
                                                                                                                                                                                                                                                                                                    5.29359182077211, 6.18749650818482, 6.08274205262864, 5.74054416447846, 
                                                                                                                                                                                                                                                                                                    5.8243477289234), BirthRate = c(70.1393031508338, 69.0057505207793, 
                                                                                                                                                                                                                                                                                                                                    72.8527814673374, 74.0066949736484, 67.5902780656335, 70.8628973685681
                                                                                                                                                                                                                                                                                                    ), CycleTally = c(0, 0, 0, 0, 0, 0), ProportionThroughCycle = c(0.0416666666666667, 
                                                                                                                                                                                                                                                                                                                                                                    0.125, 0.208333333333333, 0.291666666666667, 0.375, 0.458333333333333
                                                                                                                                                                                                                                                                                                    ), ProportionID = c(1, 2, 3, 4, 5, 6), StartingPointInCycle = c(TRUE, 
                                                                                                                                                                                                                                                                                                                                                                    FALSE, FALSE, FALSE, FALSE, FALSE), TerminalPointInCycle = c(FALSE, 
                                                                                                                                                                                                                                                                                                                                                                                                                                 FALSE, FALSE, FALSE, FALSE, FALSE), StageProgress = c(1, 
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       1.5, 1.5, 1.5, 1.5, 1.5), RollingLower = c(NA_real_, NA_real_, 
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  NA_real_, NA_real_, NA_real_, NA_real_), RollingCenter = c(NA_real_, 
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             NA_real_, NA_real_, NA_real_, NA_real_, NA_real_), RollingUpper = c(NA_real_, 
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 NA_real_, NA_real_, NA_real_, NA_real_, NA_real_)), .Names = c("Fips", 
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                "CountyName", "Year", "Month", "FecundPopulation", "BirthCount", 
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                "Date", "DaysInMonth", "DaysInYear", "StageID", "BirthRateMonthly", 
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                "BirthRate", "CycleTally", "ProportionThroughCycle", "ProportionID", 
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                "StartingPointInCycle", "TerminalPointInCycle", "StageProgress", 
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                "RollingLower", "RollingCenter", "RollingUpper"), row.names = 721:726, class = "data.frame")
  expectedPeriodicHead <- structure(list(ProportionID = c(1, 1, 2, 2, 3, 3), Date = structure(c(7319, 
                                                                                                7319, 7350, 7350, 7378, 7378), class = "Date"), StageIDTime = c(1L, 
                                                                                                                                                                1L, 1L, 1L, 1L, 1L), StageProgress = c(1, 1, 1.5, 1.5, 1.5, 1.5
                                                                                                                                                                ), StageIDBand = c(1L, 2L, 1L, 2L, 1L, 2L), ProportionThroughCycle = c(0.0416666666666667, 
                                                                                                                                                                                                                                       0.0416666666666667, 0.125, 0.125, 0.208333333333333, 0.208333333333333
                                                                                                                                                                ), PositionLower = c(66.8200512192968, 70.756002768221, 68.93747306314, 
                                                                                                                                                                                     69.3484622905977, 66.1307556378172, 70.7014853956519), PositionCenter = c(70.1393031508338, 
                                                                                                                                                                                                                                                               73.5105943925503, 69.5378223100225, 71.9644403518153, 69.7001229118945, 
                                                                                                                                                                                                                                                               71.1260225386533), PositionUpper = c(70.5504362290919, 73.5928210082019, 
                                                                                                                                                                                                                                                                                                    71.7297748904155, 74.1493189962727, 69.9197130313642, 72.5444316586437
                                                                                                                                                                                                                                                               )), .Names = c("ProportionID", "Date", "StageIDTime", "StageProgress", 
                                                                                                                                                                                                                                                                              "StageIDBand", "ProportionThroughCycle", "PositionLower", "PositionCenter", 
                                                                                                                                                                                                                                                                              "PositionUpper"), row.names = c(1L, 2L, 21L, 22L, 43L, 44L), class = "data.frame")
  
  
  
  
  expect_equal(dim(portfolio$dsStageCycle), expected=c(24, 6), label="The dimensions of dsStageCycle should be correct.")
  expect_equal(dim(portfolio$dsLinear), expected=c(120, 21), label="The dimensions of dsLinear should be correct.")
  expect_equal(dim(portfolio$dsPeriodic), expected=c(240, 9), label="The dimensions of dsPeriodic should be correct.")
  
  expect_equal(portfolio$dsStageCycle, expected=expectedStageCycle, label="The dsStageCycle should be correct.")
  expect_equal(head(portfolio$dsLinear), expected=expectedLinearHead, label="The head of the dsLinear should be correct.")
  expect_equal(head(portfolio$dsPeriodic), expected=expectedPeriodicHead, label="The head of the dsPeriodic should be correct.")
})
test_that("AnnotateDataWithMonthResolution-Median", {
  dsLinear <- CountyMonthBirthRate2005Version
  dsLinear <- dsLinear[dsLinear$CountyName=="oklahoma", ]
  dsLinear <- AugmentYearDataWithMonthResolution(dsLinear=dsLinear, dateName="Date")
  
  hSpread <- function( scores ) { return( quantile(x=scores, probs=c(.25, .75)) ) }
  portfolio <- AnnotateData(dsLinear, dvName="BirthRate", centerFunction=mean, spreadFunction=hSpread)
  
  #   head(portfolio$dsStageCycle); dput(portfolio$dsStageCycle)
  #   head(portfolio$dsLinear); dput(head(portfolio$dsLinear))
  #   head(portfolio$dsPeriodic); dput(head(portfolio$dsPeriodic))
  
  expectedStageCycle <- structure(list(StageID = c(1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 
                                                   1L, 1L, 1L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L), 
                                       ProportionID = c(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 1, 
                                                        2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12), ProportionThroughCycle = c(0.0416666666666667, 
                                                                                                                        0.125, 0.208333333333333, 0.291666666666667, 0.375, 0.458333333333333, 
                                                                                                                        0.541666666666667, 0.625, 0.708333333333333, 0.791666666666667, 
                                                                                                                        0.875, 0.958333333333333, 0.0416666666666667, 0.125, 0.208333333333333, 
                                                                                                                        0.291666666666667, 0.375, 0.458333333333333, 0.541666666666667, 
                                                                                                                        0.625, 0.708333333333333, 0.791666666666667, 0.875, 0.958333333333333
                                                        ), PositionLower = c(66.8200512192968, 68.93747306314, 66.1307556378172, 
                                                                             67.7190997634877, 67.65718575015, 70.8841392442781, 70.4065396517016, 
                                                                             71.169050712871, 71.7762980240982, 68.4803530202624, 67.0393597407677, 
                                                                             66.1307556378172, 70.756002768221, 69.3484622905977, 70.7014853956519, 
                                                                             71.1377032236438, 69.5637168412724, 70.9318607184759, 75.883451769697, 
                                                                             75.6073730916667, 79.9076880458871, 74.7234369734118, 69.2063802447064, 
                                                                             72.3861735833143), PositionCenter = c(68.4521288551249, 69.9720917388033, 
                                                                                                                   68.5265350920668, 69.5777153906798, 68.9779179109544, 71.1077900068905, 
                                                                                                                   72.6972267327964, 73.3922481402517, 72.5809868335289, 70.3763711194294, 
                                                                                                                   68.2868301146557, 67.745457336176, 71.7290177200985, 71.5333409350551, 
                                                                                                                   72.1198945156424, 72.1015606086001, 70.0639475263531, 74.1818677021063, 
                                                                                                                   77.1990776201229, 76.7094350197975, 81.2841615918953, 75.4127888744911, 
                                                                                                                   69.6949433860365, 74.3184990511274), PositionUpper = c(70.5504362290919, 
                                                                                                                                                                          71.7297748904155, 69.9197130313642, 71.5691169897759, 70.5504362290919, 
                                                                                                                                                                          72.8871026314319, 73.6339343160277, 74.9701168203666, 73.1851290574892, 
                                                                                                                                                                          72.1127419264727, 69.0148541817979, 69.1725209013298, 73.5928210082019, 
                                                                                                                                                                          74.1493189962727, 72.5444316586437, 73.4544062051884, 70.4888225869529, 
                                                                                                                                                                          77.0017994487588, 78.81421110208, 78.6257657212784, 82.9282827718495, 
                                                                                                                                                                          76.5653694836079, 72.3285867925582, 76.5529791716603)), .Names = c("StageID", 
                                                                                                                                                                                                                                             "ProportionID", "ProportionThroughCycle", "PositionLower", "PositionCenter", 
                                                                                                                                                                                                                                             "PositionUpper"), row.names = c(NA, -24L), class = "data.frame")
  expectedLinearHead <- structure(list(Fips = c(40109L, 40109L, 40109L, 40109L, 40109L, 
                                                40109L), CountyName = c("oklahoma", "oklahoma", "oklahoma", "oklahoma", 
                                                                        "oklahoma", "oklahoma"), Year = c(1990L, 1990L, 1990L, 1990L, 
                                                                                                          1990L, 1990L), Month = 1:6, FecundPopulation = c(143192, 143278.666666667, 
                                                                                                                                                           143365.333333333, 143452, 143538.666666667, 143625.333333333), 
                                       BirthCount = c(853L, 758L, 886L, 871L, 822L, 834L), Date = structure(c(7319, 
                                                                                                              7350, 7378, 7409, 7439, 7470), class = "Date"), DaysInMonth = c(31L, 
                                                                                                                                                                              28L, 31L, 30L, 31L, 30L), DaysInYear = c(365L, 365L, 365L, 
                                                                                                                                                                                                                       365L, 365L, 365L), StageID = c(1L, 1L, 1L, 1L, 1L, 1L), BirthRateMonthly = c(5.95703670596123, 
                                                                                                                                                                                                                                                                                                    5.29359182077211, 6.18749650818482, 6.08274205262864, 5.74054416447846, 
                                                                                                                                                                                                                                                                                                    5.8243477289234), BirthRate = c(70.1393031508338, 69.0057505207793, 
                                                                                                                                                                                                                                                                                                                                    72.8527814673374, 74.0066949736484, 67.5902780656335, 70.8628973685681
                                                                                                                                                                                                                                                                                                    ), CycleTally = c(0, 0, 0, 0, 0, 0), ProportionThroughCycle = c(0.0416666666666667, 
                                                                                                                                                                                                                                                                                                                                                                    0.125, 0.208333333333333, 0.291666666666667, 0.375, 0.458333333333333
                                                                                                                                                                                                                                                                                                    ), ProportionID = c(1, 2, 3, 4, 5, 6), StartingPointInCycle = c(TRUE, 
                                                                                                                                                                                                                                                                                                                                                                    FALSE, FALSE, FALSE, FALSE, FALSE), TerminalPointInCycle = c(FALSE, 
                                                                                                                                                                                                                                                                                                                                                                                                                                 FALSE, FALSE, FALSE, FALSE, FALSE), StageProgress = c(1, 
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       1.5, 1.5, 1.5, 1.5, 1.5), RollingLower = c(NA_real_, NA_real_, 
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  NA_real_, NA_real_, NA_real_, NA_real_), RollingCenter = c(NA_real_, 
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             NA_real_, NA_real_, NA_real_, NA_real_, NA_real_), RollingUpper = c(NA_real_, 
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 NA_real_, NA_real_, NA_real_, NA_real_, NA_real_)), .Names = c("Fips", 
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                "CountyName", "Year", "Month", "FecundPopulation", "BirthCount", 
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                "Date", "DaysInMonth", "DaysInYear", "StageID", "BirthRateMonthly", 
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                "BirthRate", "CycleTally", "ProportionThroughCycle", "ProportionID", 
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                "StartingPointInCycle", "TerminalPointInCycle", "StageProgress", 
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                "RollingLower", "RollingCenter", "RollingUpper"), row.names = 721:726, class = "data.frame")
  expectedPeriodicHead <- structure(list(ProportionID = c(1, 1, 2, 2, 3, 3), Date = structure(c(7319, 
                                                                                                7319, 7350, 7350, 7378, 7378), class = "Date"), StageIDTime = c(1L, 
                                                                                                                                                                1L, 1L, 1L, 1L, 1L), StageProgress = c(1, 1, 1.5, 1.5, 1.5, 1.5
                                                                                                                                                                ), StageIDBand = c(1L, 2L, 1L, 2L, 1L, 2L), ProportionThroughCycle = c(0.0416666666666667, 
                                                                                                                                                                                                                                       0.0416666666666667, 0.125, 0.125, 0.208333333333333, 0.208333333333333
                                                                                                                                                                ), PositionLower = c(66.8200512192968, 70.756002768221, 68.93747306314, 
                                                                                                                                                                                     69.3484622905977, 66.1307556378172, 70.7014853956519), PositionCenter = c(68.4521288551249, 
                                                                                                                                                                                                                                                               71.7290177200985, 69.9720917388033, 71.5333409350551, 68.5265350920668, 
                                                                                                                                                                                                                                                               72.1198945156424), PositionUpper = c(70.5504362290919, 73.5928210082019, 
                                                                                                                                                                                                                                                                                                    71.7297748904155, 74.1493189962727, 69.9197130313642, 72.5444316586437
                                                                                                                                                                                                                                                               )), .Names = c("ProportionID", "Date", "StageIDTime", "StageProgress", 
                                                                                                                                                                                                                                                                              "StageIDBand", "ProportionThroughCycle", "PositionLower", "PositionCenter", 
                                                                                                                                                                                                                                                                              "PositionUpper"), row.names = c(1L, 2L, 21L, 22L, 43L, 44L), class = "data.frame")
  expect_equal(dim(portfolio$dsStageCycle), expected=c(24, 6), label="The dimensions of dsStageCycle should be correct.")
  expect_equal(dim(portfolio$dsLinear), expected=c(120, 21), label="The dimensions of dsLinear should be correct.")
  expect_equal(dim(portfolio$dsPeriodic), expected=c(240, 9), label="The dimensions of dsPeriodic should be correct.")
  
  expect_equal(portfolio$dsStageCycle, expected=expectedStageCycle, label="The dsStageCycle should be correct.")
  expect_equal(head(portfolio$dsLinear), expected=expectedLinearHead, label="The head of the dsLinear should be correct.")
  expect_equal(head(portfolio$dsPeriodic), expected=expectedPeriodicHead, label="The head of the dsPeriodic should be correct.")
})

