% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_wavelet.R
\name{plot_wavelet}
\alias{plot_wavelet}
\title{Plots a wavelet power spectra}
\usage{
plot_wavelet(
  wavelet = NULL,
  lowerPeriod = NULL,
  upperPeriod = NULL,
  plot.COI = TRUE,
  n.levels = 100,
  palette_name = "rainbow",
  color_brewer = "grDevices",
  useRaster = TRUE,
  periodlab = "Period (metres)",
  x_lab = "depth (metres)",
  keep_editable = FALSE,
  dev_new = TRUE,
  time_dir = TRUE,
  add_lines = NULL,
  add_points = NULL,
  add_abline_h = NULL,
  add_abline_v = NULL,
  add_MTM_peaks = FALSE,
  add_data = TRUE,
  add_avg = FALSE,
  add_MTM = FALSE,
  siglvl = 0.95,
  demean_mtm = TRUE,
  detrend_mtm = TRUE,
  padfac_mtm = 5,
  tbw_mtm = 3,
  plot_horizontal = TRUE
)
}
\arguments{
\item{wavelet}{wavelet object created using the \code{\link{analyze_wavelet}} function.}

\item{lowerPeriod}{Lowest period value which will be plotted}

\item{upperPeriod}{Highest period value which will be plotted}

\item{plot.COI}{Option to plot the cone of influence \code{Default=TRUE}.}

\item{n.levels}{Number of color levels \code{Default=100}.}

\item{palette_name}{Name of the color palette which is used for plotting.
The color palettes than can be chosen depends on which the R package is specified in
the color_brewer parameter. The included R packages from which palettes can be chosen
from are; the 'RColorBrewer', 'grDevices', 'ColorRamps' and 'Viridis' R packages.
There are many options to choose from so please
read the documentation of these packages \code{Default=rainbow}.
The R package 'viridis' has the color palette options: “magma”, “plasma”,
“inferno”, “viridis”, “mako”, and “rocket”  and “turbo”
To see the color palette options of the The R pacakge 'RColorBrewer' run
the RColorBrewer::brewer.pal.info() function
The R package 'colorRamps' has the color palette options:"blue2green",
"blue2green2red", "blue2red",    "blue2yellow", "colorRamps",    "cyan2yellow",
"green2red", "magenta2green", "matlab.like", "matlab.like2" and    "ygobb"
The R package 'grDevices' has the built in  palette options:"rainbow",
"heat.colors", "terrain.colors","topo.colors" and "cm.colors"
To see even more color palette options of the The R pacakge 'grDevices' run
the grDevices::hcl.pals() function}

\item{color_brewer}{Name of the R package from which the color palette is chosen from.
The included R packages from which palettes can be chosen
are; the RColorBrewer, grDevices, ColorRamps and Viridis R packages.
There are many options to choose from so please
read the documentation of these packages. "\code{Default=grDevices}}

\item{useRaster}{Plot as a raster or vector image \code{Default=TRUE}.
WARNING plotting as a vector image is computationally intensive.}

\item{periodlab}{Label for the y-axis \code{Default="Period (metres)"}.}

\item{x_lab}{Label for the x-axis \code{Default="depth (metres)"}.}

\item{keep_editable}{Keep option to add extra features after plotting  \code{Default=FALSE}}

\item{dev_new}{Opens a new plotting window to plot the plot, this guarantees a "nice" looking plot however when plotting in an R markdown
document the plot might not plot  \code{Default=TRUE}}

\item{time_dir}{The direction of the proxy record which is assumed for tuning if time increases with increasing depth/time values
(e.g. bore hole data which gets older with increasing depth ) then time_dir should be set to TRUE
if time decreases with depth/time values (eg stratospheric logs where 0m is the bottom of the section)
then time_dir should be set to FALSE \code{time_dir=TRUE}}

\item{add_lines}{Add  lines to the wavelet plot input should be matrix with first axis being depth/time the columns after that
should be period values  \code{Default=NULL}}

\item{add_points}{Add points to the wavelet plot input should be matrix with first axis being depth/time and columns after that
should be period values \code{Default=NULL}}

\item{add_abline_h}{Add horizontal lines to the plot. Specify the lines as a vector e.g. c(2,3,5,6)  \code{Default=NULL}}

\item{add_abline_v}{Add vertical lines to the plot. Specify the lines as a vector e.g. c(2,3,5,6)  \code{Default=NULL}}

\item{add_MTM_peaks}{Add the MTM peak periods as horizontal lines \code{Default=FALSE}}

\item{add_data}{Plot the data on top of the wavelet \code{Default=TRUE}}

\item{add_avg}{Plot the average wavelet spectral power to the side of the wavelet \code{Default=FALSE}}

\item{add_MTM}{Add the MTM  plot next to the wavelet plot \code{Default=FALSE}}

\item{siglvl}{Set the significance level for the MTM analysis (0-1) \code{Default=0.95}}

\item{demean_mtm}{Remove mean from data before conducting the MTM analysis \code{Default=TRUE}}

\item{detrend_mtm}{Remove mean from data before conducting the MTM analysis \code{Default=TRUE}}

\item{padfac_mtm}{Pad factor for the MTM analysis \code{Default=5}}

\item{tbw_mtm}{time bandwidth product of the MTM analysis  \code{Default=3}}

\item{plot_horizontal}{plot the wavelet horizontal or vertical eg y axis is depth or y axis power \code{Default=TRUE}}
}
\value{
The output is a plot of a wavelet spectra.
if add_MTM_peaks = TRUE then the output of the MTM analysis will given as matrix
}
\description{
Plot wavelet spectra using the outcome of the \code{\link{analyze_wavelet}} function.
}
\examples{
\donttest{
#Example 1. A plot of a wavelet spectra using the Total Solar Irradiance
# data set of Steinhilber et al., (2012)

TSI_wt <-
 analyze_wavelet(
   data = TSI,
   dj = 1/200,
   lowerPeriod = 16,
   upperPeriod = 8192,
   verbose = FALSE,
   omega_nr = 6
 )

plot_wavelet(
 wavelet = TSI_wt,
 lowerPeriod = NULL,
 upperPeriod = NULL,
 plot.COI = TRUE,
 n.levels = 100,
 palette_name = "rainbow",
color_brewer= "grDevices",
 useRaster = TRUE,
 periodlab = "Period (metres)",
 x_lab = "depth (metres)",
 keep_editable = FALSE,
 dev_new=TRUE,
 time_dir = TRUE,
 add_lines = NULL,
 add_points= NULL,
 add_abline_h = NULL,
 add_abline_v = NULL,
 add_MTM_peaks = FALSE,
 add_data = TRUE,
 add_avg = TRUE,
 add_MTM = FALSE,
 siglvl = 0.95,
 demean_mtm = TRUE,
 detrend_mtm = TRUE,
 padfac_mtm = 5,
 tbw_mtm = 3,
 plot_horizontal=TRUE)

#Example 2. A plot of a wavelet spectra using the magnetic susceptibility
#data set of Pas et al., (2018)
mag_wt <-
analyze_wavelet(
data = mag,
dj = 1/100,
lowerPeriod = 0.1,
upperPeriod = 254,
verbose = FALSE,
omega_nr = 10
)

plot_wavelet(
wavelet = mag_wt,
lowerPeriod = NULL,
upperPeriod = NULL,
plot.COI = TRUE,
n.levels = 100,
palette_name = "rainbow",
color_brewer= "grDevices",
useRaster = TRUE,
periodlab = "Period (metres)",
x_lab = "depth (metres)",
keep_editable = FALSE,
dev_new=TRUE,
time_dir = TRUE,
add_lines= NULL,
add_points= NULL,
add_abline_h = NULL,
add_abline_v = NULL,
add_MTM_peaks = FALSE,
add_data = TRUE,
add_avg = TRUE,
add_MTM = FALSE,
siglvl = 0.95,
demean_mtm = TRUE,
detrend_mtm = TRUE,
padfac_mtm = 5,
tbw_mtm = 3,
plot_horizontal=TRUE)


#Example 3. A plot of a wavelet spectra using the greyscale
# data set of Zeeden et al., (2013)
grey_wt <-
 analyze_wavelet(
   data = grey,
   dj = 1/200,
   lowerPeriod = 0.02,
   upperPeriod = 256,
   verbose = FALSE,
   omega_nr = 8
 )

plot_wavelet(
wavelet = grey_wt,
lowerPeriod = NULL,
upperPeriod = NULL,
plot.COI = TRUE,
n.levels = 100,
palette_name = "rainbow",
color_brewer= "grDevices",
useRaster = TRUE,
periodlab = "Period (metres)",
x_lab = "depth (metres)",
keep_editable = FALSE,
dev_new=TRUE,
time_dir = TRUE,
add_lines = NULL,
add_points= NULL,
add_abline_h = NULL,
add_abline_v = NULL,
add_MTM_peaks = FALSE,
add_data = TRUE,
add_avg = TRUE,
add_MTM = FALSE,
siglvl = 0.95,
demean_mtm = TRUE,
detrend_mtm = TRUE,
padfac_mtm = 5,
tbw_mtm = 3,
plot_horizontal=TRUE)

}

}
\references{
Angi Roesch and Harald Schmidbauer (2018). WaveletComp: Computational
Wavelet Analysis. R package version 1.1.
\url{https://CRAN.R-project.org/package=WaveletComp}

Gouhier TC, Grinsted A, Simko V (2021). R package biwavelet: Conduct Univariate and Bivariate Wavelet Analyses. (Version 0.20.21),
\url{https://github.com/tgouhier/biwavelet}

Torrence, C., and G. P. Compo. 1998. A Practical Guide to Wavelet Analysis.
Bulletin of the American Meteorological Society 79:61-78.
\url{https://paos.colorado.edu/research/wavelets/bams_79_01_0061.pdf}

Morlet, Jean, Georges Arens, Eliane Fourgeau, and Dominique Glard.
"Wave propagation and sampling theory—Part I: Complex signal and scattering in multilayered media.
" Geophysics 47, no. 2 (1982): 203-221.
\doi{<doi:10.1190/1.1441328>}

J. Morlet, G. Arens, E. Fourgeau, D. Giard;
Wave propagation and sampling theory; Part II, Sampling theory and complex waves.
 Geophysics 1982 47 (2): 222–236. <\doi{doi:10.1190/1.1441329}>

S.R. Meyers, 2012, Seeing Red in Cyclic Stratigraphy: Spectral Noise Estimation for
Astrochronology: Paleoceanography, 27, PA3228, <\doi{doi:10.1029/2012PA002307}>
}
\author{
Code based on the \link[WaveletComp]{analyze.wavelet} and \link[WaveletComp]{wt.image} functions of the 'WaveletComp' R package
and \link[biwavelet]{wt} function of the 'biwavelet' R package which are based on the
wavelet MATLAB code written by Christopher Torrence and Gibert P. Compo (1998).
The MTM analysis is from the astrochron R package of Meyers et al., (2012)
}
