% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/webpower.R
\name{wp.effect.CRT3arm}
\alias{wp.effect.CRT3arm}
\title{Effect size calculatator based on raw data for Cluster Randomized Trials with 3 Arms}
\usage{
wp.effect.CRT3arm(file)
}
\arguments{
\item{file}{The input data set.
The first column of the data is the ID variable,
the second column represents cluster, the third column is the outcome variable,
and the fourth column is the condition variable (0 for control, 1 for treatment1, 2 for treatment2).}
}
\value{
A list including effect size f1, f2, f3, and ICC.
}
\description{
This function is for effect size and ICC calculation for Cluster randomized trials (CRT) with 3 arms based on empirical data.
CRT are a type of multilevel design for the situation when the entire cluster is randomly assigned to either a treatment arm or a contral arm \cite{(Liu, 2013)}.
The data from CRT can be analyzed in a two-level hierachical linear model, where the indicator variable for treatment assignment is included in second level. If a study contains multiple treatments, then mutiple indicators will be used.
This function is for designs with 3 arms (i.e., two treatments and a control).
Details leading to power calculation can be found in \cite{Raudenbush (1997)} and \cite{Liu (2013)}.
The Effect size f specifies the main effect of treatment, the mean difference between the treatment clusters and the control clusters.
This function is used to calculate the effect size with a input data set.
}
\examples{
\donttest{
#To calculate the effect sizes based on empirical data
wp.effect.CRT3arm (CRT3)
#  Effect size for CRT3arm
#  
#  f1         f2        f3       ICC
#  0.6389258 -0.6189113 0.3931397 -0.019794
#  
#  NOTE: f1 for treatment main effect;
#        f2 for difference between two treatments;
#        f3 for effect size of omnibus test.
#  URL: http://psychstat.org/crt3arm
}

}
\references{
Liu, X. S. (2013). Statistical power analysis for the social and behavioral sciences: basic and advanced techniques. Routledge.

Raudenbush, S. W. (1997). Statistical analysis and optimal design for cluster randomized trials. Psychological Methods, 2(2), 173.
}
