% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/webpower.R
\name{wp.logistic}
\alias{wp.logistic}
\title{Statistical Power Analysis for Logistic Regression}
\usage{
wp.logistic(n = NULL, p0 = NULL, p1 = NULL, alpha = 0.05,
  power = NULL, alternative = c("two.sided", "less", "greater"),
  family = c("Bernoulli", "exponential", "lognormal", "normal", "Poisson",
  "uniform"), parameter = NULL)
}
\arguments{
\item{n}{Sample size.}

\item{p0}{Prob(\cite{Y=1|X=0}): the probobility of observieng 1 for the outcome variable Y when the predictor X equals 0.}

\item{p1}{Prob(\cite{Y=1|X=1}): the probobility of observieng 1 for the outcome variable Y when the predictor X equals 1.}

\item{alpha}{significance level chosed for the test. It equals 0.05 by default.}

\item{power}{Statistical power.}

\item{alternative}{Direction of the alternative hypothesis (\code{"two.sided"} or \code{"less"} or \code{"greater"}). The default is "two.sided".}

\item{family}{Distribution of the predictor (\code{"Bernoulli"},\code{"exponential"},
\code{"lognormal"}, \code{"normal"}, \code{"Poisson"}, \code{"uniform"}). The default is "Bernoulli".}

\item{parameter}{Corresponding parameter for the predictor's distribution.
The default is 0.5 for "Bernoulli", 1 for "exponential", (0,1) for "lognormal" or "normal", 1 for "Poisson", and (0,1) for "uniform".}
}
\value{
An object of the power analysis.
}
\description{
This function is for Logistic regression models. Logistic regression is a type of generalized linear models where the outcome variable follows Bernoulli distribution. 
Here, Maximum likelihood methods is used to estimate the model parameters. The estimated regression coefficent is assumed to follow a normal distribution.
A Wald test is use to test the mean difference between the estimated parameter and the null parameter (tipically the null hypothesis assumes it equals 0).
The procedure introduced by \cite{Demidenko (2007)} is adopted here for computing the statistical power.
}
\examples{
\donttest{
#To calculate the statistical power given sample size and effect size:
wp.logistic(n = 200, p0 = 0.15, p1 = 0.1, alpha = 0.05,
            power = NULL, family = "normal", parameter = c(0,1))
#  Power for logistic regression
#
#      p0  p1     beta0      beta1   n alpha     power
#    0.15 0.1 -1.734601 -0.4626235 200  0.05 0.6299315
#
#  URL: http://psychstat.org/logistic

#To generate a power curve given a sequence of sample sizes:
res <- wp.logistic(n = seq(100,500,50), p0 = 0.15, p1 = 0.1, alpha = 0.05,
                power = NULL, family = "normal", parameter = c(0,1))
res
#  Power for logistic regression
#
#      p0  p1     beta0      beta1   n alpha     power
#    0.15 0.1 -1.734601 -0.4626235 100  0.05 0.3672683
#    0.15 0.1 -1.734601 -0.4626235 150  0.05 0.5098635
#    0.15 0.1 -1.734601 -0.4626235 200  0.05 0.6299315
#    0.15 0.1 -1.734601 -0.4626235 250  0.05 0.7264597
#    0.15 0.1 -1.734601 -0.4626235 300  0.05 0.8014116
#    0.15 0.1 -1.734601 -0.4626235 350  0.05 0.8580388
#    0.15 0.1 -1.734601 -0.4626235 400  0.05 0.8998785
#    0.15 0.1 -1.734601 -0.4626235 450  0.05 0.9302222
#    0.15 0.1 -1.734601 -0.4626235 500  0.05 0.9518824
#
#  URL: http://psychstat.org/logistic

#To plot the power curve:
plot(res)

#To calculate the required sample size given power and effect size:
wp.logistic(n = NULL, p0 = 0.15, p1 = 0.1, alpha = 0.05,
              power = 0.8, family = "normal", parameter = c(0,1))
#  Power for logistic regression
#
#      p0  p1     beta0      beta1        n alpha power
#    0.15 0.1 -1.734601 -0.4626235 298.9207  0.05   0.8
#
#  URL: http://psychstat.org/logistic
}

}
\references{
Demidenko, E. (2007). Sample size determination for logistic regression revisited. Statistics in medicine, 26(18), 3385-3397.

Zhang, Z., & Yuan, K.-H. (2018). Practical Statistical Power Analysis Using Webpower and R (Eds). Granger, IN: ISDSA Press.
}
