% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weightit_methods.R
\docType{data}
\name{.weightit_methods}
\alias{.weightit_methods}
\title{Weighting methods}
\format{
An object of class \code{list} of length 10.
}
\usage{
.weightit_methods
}
\description{
\code{.weightit_methods} is a list containing the allowable weighting
methods that can be supplied by name to the \code{method} argument of
\code{\link[=weightit]{weightit()}}, \code{\link[=weightitMSM]{weightitMSM()}}, and \code{\link[=weightit.fit]{weightit.fit()}}. Each entry corresponds
to an allowed method and contains information about what options are and
are not allowed for each method. While this list is primarily for internal
use by checking functions in \pkg{WeightIt}, it might be of use for package
authors that want to support different weighting methods.
}
\details{
Each component is itself a list containing the following components:
\describe{
\item{\code{treat_type}}{at least one of \code{"binary"}, \code{"multi-category"}, or
\code{"continuous"} indicating which treatment types are
available for this method.}
\item{\code{estimand}}{which estimands are available for this method. All methods that support binary and multi-category treatments accept \code{"ATE"}, \code{"ATT"}, and \code{"ATC"}, as well as some other estimands depending on the method. See \code{\link[=get_w_from_ps]{get_w_from_ps()}} for more details about what each estimand means.}
\item{\code{alias}}{a character vector of aliases for the method. When an alias is supplied, the corresponding method will still be dispatched. For example, the canonical method to request entropy balancing is \code{"ebal"}, but \code{"ebalance"} and \code{"entropy"} also work. The first value is the canonical name.}
\item{\code{description}}{a string containing the description of the name in English.}
\item{\code{ps}}{a logical for whether propensity scores are returned by the method for binary treatments. Propensity scores are never returned for multi-category or continuous treatments.}
\item{\code{msm_valid}}{a logical for whether the method can be validly used with longitudinal treatments.}
\item{\code{msm_method_available}}{a logical for whether a version of the method can be used that estimates weights using a single model rather than multiplying the weights across time points. This is related to the \code{is.MSM.method} argument of \code{weightitMSM()}.}
\item{\code{subclass_ok}}{a logical for whether \code{subclass} can be supplied to compute subclassification weights from the propensity scores.}
\item{\code{packages_needed}}{a character vector of the minimal packages required to use the method. Some methods may require additional packages for certain options.}
\item{\code{s.weights_ok}}{a logical for whether sampling weights can be used with the method.}
\item{\code{missing}}{a character vector of the allowed options that can be supplied to \code{missing} when missing data is present. All methods accept \code{"ind"} for the missingness indicator approach; some other methods accept additional values.}
\item{\code{moments_int_ok}}{a logical for whether \code{moments}, \code{int}, and \code{quantile} can be used with the method.}
\item{\code{moments_default}}{when \code{moments_int_ok} is \code{TRUE}, the default value of \code{moments} used with the method. For most methods, this is 1.}
\item{\code{density_ok}}{a logical for whether arguments that control the density can be used with the method when used with a continuous treatment.}
\item{\code{stabilize_ok}}{a logical for whether the \code{stabilize} argument (and \code{num.formula} for longitudinal treatments) can be used with the method.}
\item{\code{plot.weightit_ok}}{a logical for whether \code{plot()} can be used on the \code{weightit} output with the method.}
}
}
\examples{
# Get all acceptable names
names(.weightit_methods)

# Get all acceptable names and aliases
lapply(.weightit_methods, `[[`, "alias")

# Which estimands are allowed with `method = "bart"`
.weightit_methods[["bart"]]$estimand

# All methods that support continuous treatments
supp <- sapply(.weightit_methods, function(x) {
  "continuous" \%in\% x$treat_type
})
names(.weightit_methods)[supp]

# All methods that return propensity scores (for
# binary treatments only)
supp <- sapply(.weightit_methods, `[[`, "ps")
names(.weightit_methods)[supp]
}
\seealso{
\code{\link[=weightit]{weightit()}} and \code{\link[=weightitMSM]{weightitMSM()}} for how the methods are used. Also
see the individual methods pages for information on whether and how each
option can be used.
}
\keyword{datasets}
