% Generated by roxygen2 (4.0.2): do not edit by hand
\name{whitestripe_hybrid}
\alias{hybrid}
\alias{whitestripe_hybrid}
\title{Hybrid WhiteStripe}
\usage{
whitestripe_hybrid(t1, t2, ...)
}
\arguments{
\item{t1}{T1 image, array or class nifti}

\item{t2}{T2 image, array or class nifti}

\item{...}{arguments passed to \code{\link{whitestripe}}}
}
\value{
List of indices of overlap mask, and overlap of class array or nifti
}
\description{
Uses t1 and t2 WhiteStripe to get an intersection of
the two masks for a hybrid approach
}
\examples{
\dontrun{
if (download_img_data()){
t1 = readNIfTI(system.file("T1Strip.nii.gz", package="WhiteStripe"))
t2 = readNIfTI(system.file("T2Strip.nii.gz", package="WhiteStripe"))
ind = whitestripe_hybrid(t1, t2)
}
}
}
\seealso{
whitestripe
}
\keyword{hybrid,}
\keyword{whitestripe}

