\name{YPmodel.estimate}
\alias{YPmodel.estimate}
\alias{summary.YPmodel.estimate}
\alias{plot.YPmodel.survivor}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
%%  ~~function to do ... ~~
YPmodel Estimate Parameters.
}
\description{
The main function to fit the short-term and long-term hazard ration model.
}
\usage{

\method{YPmodel}{estimate}(data, startPoint, nm, maxIter1, maxIter2, interval, Internal, ...)
\method{summary}{YPmodel.estimate}(object,...)
\method{plot}{YPmodel.survivor}(x, Internal, ...)

}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{\dots}{ For S4 method only. }
  \item{data}{ A properly qualified filename where text data is to be saved, or a dataframe of input data set with three vectors: the event / censoring time (unite: year), the censoring indicator, and the group membership indicator. See the structure of sample data set \code{\link{gastric}} for instance.} 
  \item{startPoint}{ Start point for estimating \eqn{\hat{\beta}}. }
  \item{nm}{The upper boundary for the absolute value of \eqn{\hat{\beta}}, and the default value is \eqn{\log(100)}.  }
  \item{maxIter1}{ Parameter of out-cycle iteration numbers. }
  \item{maxIter2}{ Parameter of inner-cycle iteration numbers. }
  \item{interval}{ A binary parameter to control whether or not to perform interval estimation of \eqn{\hat{\beta}}, when it is set as 1, the interval estimation will be performed. }
  \item{Internal}{A dataframe of internal parameters, used only to perform hypothesis tests and plot (and to accelerate the speed). }
  \item{x}{ A dataframe of estimation results, including estimation of \eqn{\hat{\beta}} and and its confidential intervals and \eqn{\hat{R}(t,\hat{\beta})}, generated by \code{\link{YPmodel.estimate}}. }
  \item{object}{ A dataframe of estimation results, including estimation of \eqn{\hat{\beta}} and and its confidential intervals and \eqn{\hat{R}(t,\hat{\beta})}, generated by \code{\link{YPmodel.estimate}}, equally to x (different symbol for S4 method only).}
}
\value{
    \item{beta}{ Value of \eqn{\hat{\beta}}. }
    \item{r}{ Value of \eqn{\hat{R}(t,\hat{\beta})}.}
    \item{variance.beta1}{ Variance of the first variable of \eqn{\hat{\beta}}.  }
    \item{variance.beta2}{ Variance of the second variable of \eqn{\hat{\beta}}. }
}
\references{
YANG, S. AND PRENTICE, R. L. (2005). Semiparametric analysis of short-term and long-term hazard ratios with two-sample survival data. Biometrika 92, 1-17.  
}
\author{
Junlong Sun and Song Yang
}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
%% ~~objects to See Also as \code{\link{help}}, ~~~
\code{\link{YPmodel}}
}
\examples{
    library(YPmodel)
    data(gastric)
    Estimate <- YPmodel.estimate(data=gastric, interval=1)

    Estimate <- YPmodel.estimate(data=gastric, startPoint=c(0,0), nm=log(100))

    Estimate <- YPmodel.estimate(data=gastric, maxIter1=50, maxIter2=20)

    summary.YPmodel.estimate(Estimate)

    plot.YPmodel.survivor(Estimate)
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{YPmodel}
