% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Silhouette.R
\name{Silhouette}
\alias{Silhouette}
\title{Calculates the area of the 2D convex hull of a projected plant}
\usage{
Silhouette(obj, azimuth = NA, altitude = NA)
}
\arguments{
\item{obj}{Either a \code{plant3d} object, or a \code{projectedplant3d}
object.}

\item{azimuth, altitude}{Viewing azimuth and altitude (ignored if a projected
plant is given as input).}
}
\description{
Calculates the so-called 'silhouette area' of a projected plant. That is, the area of the (convex) outline of a projection of a plant onto a plane.
}
\note{
Not usually called by the user. Use instead, \code{\link{STARbar}} and
\code{\link{projectplant}}. For the latter, see the option
\code{silhouette=TRUE}.
}
\examples{


# Silhouette returns the area of the 2D convex hull (H), and the coordinates of the 2D hull (xyz):
Silhouette(sugarmaple, altitude=0, azimuth=45)

}
\author{
Remko Duursma
}
\seealso{
\code{\link{summary.plant3d}},\code{\link{STARbar}},\code{\link{projectplant}}
}
\keyword{misc}

