% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetMonthlyPayments.R
\name{GetMonthlyPayments}
\alias{GetMonthlyPayments}
\title{Make request to Zillow API GetMonthlyPayments Web Service}
\usage{
GetMonthlyPayments(price = NULL, down = NULL, dollarsdown = NULL,
  zip = NULL, zws_id = getOption("ZillowR-zws_id"),
  url = "http://www.zillow.com/webservice/GetMonthlyPayments.htm")
}
\arguments{
\item{price}{The price of the property for which monthly payment data will be
calculated. Required.}

\item{down}{The percentage of the total property price that will be placed as
a down payment. If omitted, a 20% down payment is assumed. If the down
payment is less than 20%, a monthly private mortgage insurance amount is
specified for each returned loan type.}

\item{dollarsdown}{The dollar amount that will be placed as a down payment.
This amount will be used for the down payment if the 'down' parameter is
omitted. If the down payment is less than 20% of the purchase price, a
monthly private mortgage insurance amount is specified for each returned
loan type.}

\item{zip}{The ZIP code in which the property is located. If omitted, monthly
property tax and hazard insurance data will not be returned.}

\item{zws_id}{The Zillow Web Service Identifier. Required.}

\item{url}{URL for the GetMonthlyPayments Web Service. Required.}
}
\value{
A named list with the following elements:
    \describe{
        \item{\strong{request}}{a list with the request parameters}
        \item{\strong{message}}{a list of status code(s) and message(s)
            returned by the API}
        \item{\strong{response}}{an XMLNode with the API-specific response
            values. At this time, no further coercion is performed, so you
            may have to use functions from the \code{XML} package to extract
            the desired output.}
    }
}
\description{
For a specific loan amount, the GetMonthlyPayments API returns the estimated
monthly payment that includes principal and interest based on today's
mortgage rate. The API returns the estimated monthly payment per loan type
(30-year fixed, 15-year fixed, and 5/1 ARM). If a ZIP code is entered, the
estimated taxes and insurance are returned in the result set.
}
\examples{
\dontrun{
GetMonthlyPayments(price = 300000L)
GetMonthlyPayments(price = 300000L, down = 10)
GetMonthlyPayments(price = 300000L, dollarsdown = 10000L)
GetMonthlyPayments(price = 300000L, zip = 98109)}
}

