% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/canvas_mandelbrot.R
\name{canvas_mandelbrot}
\alias{canvas_mandelbrot}
\title{Draw the Mandelbrot Set}
\usage{
canvas_mandelbrot(
  colors,
  iterations = 100,
  zoom = 1,
  set = c("mandelbrot", "multibrot", "julia", "ship"),
  left = -2.16,
  right = 1.16,
  bottom = -1.66,
  top = 1.66,
  resolution = 500
)
}
\arguments{
\item{colors}{a string or character vector specifying the color(s) used for the artwork.}

\item{iterations}{a positive integer specifying the number of iterations of the algorithm.}

\item{zoom}{a positive value specifying the amount of zoom to apply.}

\item{set}{a character indicating which fractal set to draw. Possible options are \code{mandelbrot} for the Mandelbrot set, \code{multibrot} for variations of the Mandelbrot set (aka the Multibrot sets), \code{julia} for the Julia set and \code{ship} for the Burning ship set.}

\item{left}{a value specifying the minimum location on the x-axis.}

\item{right}{a value specifying the maximum location on the x-axis.}

\item{bottom}{a value specifying the minimum location on the y-axis.}

\item{top}{a value specifying the maximum location on the y-axis.}

\item{resolution}{resolution of the artwork in pixels per row/column. Increasing the resolution increases the quality of the artwork but also increases the computation time exponentially.}
}
\value{
A \code{ggplot} object containing the artwork.
}
\description{
This function draws the Mandelbrot set and other related fractal sets on the canvas.
}
\examples{
\donttest{
canvas_mandelbrot(colors = colorPalette("tuscany1"), set = "mandelbrot")
canvas_mandelbrot(colors = colorPalette("flag"), set = "julia", zoom = 2)
}

}
\references{
\url{https://en.wikipedia.org/wiki/Mandelbrot_set}
}
\seealso{
\code{colorPalette}
}
\author{
Koen Derks, \email{koen-derks@hotmail.com}
}
\keyword{artwork}
\keyword{canvas}
