% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/aSPUMpath.r
\name{aSPUMpath}
\alias{aSPUMpath}
\title{Pathway based Sum of Powered Score tests (SPUpath) and adaptive SPUpath (aSPUpath) test for meta-analyzed data.}
\usage{
aSPUMpath(Zs, corrSNP, pow = c(1, 2, 4, 8, Inf), pow2 = c(1, 2, 4, 8),
  snp.info, gene.info, n.perm = 1000, Ps = FALSE)
}
\arguments{
\item{Zs}{Z-scores for each SNPs. It could be P-values if the Ps option is TRUE.}

\item{corrSNP}{Correaltion matirx of SNPs. Estimated from the reference population.}

\item{pow}{SNP specific power(gamma values) used in SPUpath test.}

\item{pow2}{GENE specific power(gamma values) used in SPUpath test.}

\item{snp.info}{SNP information matrix, the 1st column is SNP id, 2nd column is chromosome #, 3rd column indicates SNP location.}

\item{gene.info}{GENE information matrix, The 1st column is GENE id, 2nd column is chromosome #, 3rd and 4th column indicate start and end positions of the gene.}

\item{n.perm}{number of permutations.}

\item{Ps}{TRUE if input is p-value, FALSE if input is Z-scores. The default is FALSE.}
}
\value{
P-values for SPUMpath tests and aSPUMpath test.
}
\description{
It gives p-values of the SPUpath tests and aSPUpath test for meta-analyzed data.
}
\examples{
data(kegg9)

# p-values of SPUpath and aSPUpath tests.
out.a <- aSPUMpath(kegg9$nZ, corrSNP = kegg9$ldmatrix, pow=c(1:8, Inf),
                  pow2 = c(1,2,4,8),
                  snp.info=kegg9$snp.info, gene.info = kegg9$gene.info,
                  n.perm=10, Ps = TRUE)
out.a
}
\author{
Il-Youp Kwak and Wei Pan
}
\references{
Wei Pan, Il-Youp Kwak and Peng Wei (2015)
A Powerful and Pathway-Based Adaptive Test for Genetic Association With Common or Rare Variants (Submitted)
}
\seealso{
\code{\link{simPathAR1Snp}} \code{\link{aSPUpathSingle}} \code{\link{aSPUpath}}
}

