% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simPathAR1SNP.R
\name{simPathAR1Snp}
\alias{simPathAR1Snp}
\title{Simulating a pathway with multiple SNPs.}
\usage{
simPathAR1Snp(nGenes = 10, nGenes1 = 5, nSNPs = NULL, ncSNPs = NULL,
  nSNPlim = c(1, 20), nSNP0 = 1:3, LOR = 0.3, n = 100,
  MAFlim = c(0.05, 0.4), rholim = c(0, 0), p0 = 0.05, noncausal = FALSE)
}
\arguments{
\item{nGenes}{The number of total genes.}

\item{nGenes1}{The number of causal genes.}

\item{nSNPs}{A vector, length matched with total number of genes. Each elements of vector indicate the number of SNPs in the gene. Default is nSNPs = NULL, in this case the number of nSNPs randomly selected from nSNPlow to nSNPup.}

\item{ncSNPs}{A vector, length matched with total number of genes. Each elements of vector indicate the number of causal SNPs in the gene. Default is ncSNPs = NULL, in this case the number of ncSNPs are randomly selected from nSNP0.}

\item{nSNPlim}{If nSNPs = NULL, the number of SNPs in Gene randomly selected from Unif(nSNPlim[1], nSNPlim[2]).}

\item{nSNP0}{If ncSNPs = NULL, the number of causal SNPs in Gene randomly selected from nSNP0. Default is 1:3.}

\item{LOR}{Association in log OR between a causal SNP and outcome.}

\item{n}{# of cases (= # of controls).}

\item{MAFlim}{MAF's of the SNPs are drawn from Unif(MAFlim[1], MAFlim[2]).}

\item{rholim}{the SNPs in eahc gene are from a latent Normal
variable with a AR(rho) corr structure, rho's are drawn
from Unif(rholim[1], rholim[2]); the SNPs in diff genes are independant.}

\item{p0}{background disease prevalence;i.e. intercept=log(p0/(1-p0)).}

\item{noncausal}{exclude causal SNPs if TRUE, it is the simulation set up d in the paper(Pan et al 2015).}
}
\value{
a list of the binary outcome Y (=0 or 1) and SNPs (=0, 1 or 2);
              Y is a vector of length 2n; X is a matrix of 2n by nSNP.
}
\description{
It gives a simulated SNPs consisting of multiple genes in a pathway. Each SNPs from a latent multivariate Gaussian variable with an AR1 correlation structure.
}
\examples{

# Simulation set up A a) in the paper (Pan et al 2015)
\dontrun{ simula <- simPathAR1Snp(nGenes=20, nGenes1=1, nSNPlim=c(1, 20), nSNP0=1:3,
                           LOR=.2, rholim=c(0,0),
                           n=100, MAFlim=c(0.05, 0.4), p0=0.05) }
\dontshow{ simula <- simPathAR1Snp(nGenes=20, nGenes1=1, nSNPlim=c(1, 20), nSNP0=1:3,
                           LOR=.2, rholim=c(0,0),
                           n=10, MAFlim=c(0.05, 0.4), p0=0.05) }

# Simulation set up A b) in the paper
#simulb <- simPathAR1Snp(nGenes=20, nGenes1=1, nSNPlim=c(1, 100), nSNP0=1:3,
#                           LOR=.2, rholim=c(0,0),
#                           n=100, MAFlim=c(0.05, 0.4), p0=0.05)



}
\seealso{
\code{\link{aSPUpath}}
}

