% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aSPUr.R
\name{aSPUr}
\alias{aSPUr}
\title{Robust Sum of powered score (SPU) tests and aSPU test for a quantitative trait}
\usage{
aSPUr(Y, X, cov = NULL, pow = c(1:8, Inf), B = 1000, C = 1.345)
}
\arguments{
\item{Y}{a vector of quantitative traits (QTs).}

\item{X}{Genotype or other data; each row for a subject, and each column
for an SNP (or a predictor). The value of each SNP is the # of the copies
for an allele. A matrix with dimension n by k (n : number of observation, k : number of SNPs (or predictors) ).}

\item{cov}{Covariates. A matrix with dimension n by k2 (n :number of observation, k2 : number of covariates).}

\item{pow}{power used in SPUr test. A vector of the powers.}

\item{B}{number of bootstraps.}

\item{C}{Constant in huber loss function. C = 1.345 is chosen to maintain a high efficiency for a Normal error.}
}
\value{
p-values of the SPUr tests in the order of supplied pow values; finally, the p-value of the aSPUr test (that combines the SPUs tests with pow by taking their min P-value and adjust for multiple testing).
}
\description{
The test is based on the Huber loss function and using the parametric
bootstrap for inference (i.e. bootstrapping residuals).
}
\examples{


data(exdat)

## example analysis using aSPU test on exdat data.

QT <- jitter(exdat$Y)

out <- aSPUr(Y = QT, X = exdat$X, cov = NULL, B = 100)
out
## This is a vector of p-values for SPUr and aSPUr tests.
## SPU1 to SPUInf corresponds with the option pow=c(1:8, Inf)
## They are p-values for corresponding SPUr tests.
## The last element is p-value of aSPUr test.

}
\author{
Yiwei Zhang and Wei Pan
}
\references{
Peng Wei, Ying Cao, Yiwei Zhang, Zhiyuan Xu, Il-Youp Kwak, Eric Boerwinkle, Wei Pan (in press) On Robust Association Testing for Quantitative Traits and Rare Variants, G3.
}
\seealso{
\code{\link{aSPU}}
}

