% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MTaSPUsSetPath.R
\name{MTaSPUsSetPath}
\alias{MTaSPUsSetPath}
\title{Multitraits - Pathway based Sum of Powered Score tests (MTSPUsSetPath) and adaptive MTSPUsSetpath (MTaSPUsSetPath) test for multi trait - pathway association with GWAS summary statistics.}
\usage{
MTaSPUsSetPath(Zs, corPhe, corSNP, pow1 = c(1, 2, 4, 8), pow2 = c(1, 2, 4,
  8), pow3 = c(1, 2, 4, 8), snp.info, gene.info, n.perm = 1000,
  Ps = FALSE, prune = TRUE)
}
\arguments{
\item{Zs}{Z-score matrix. row represent SNPs and column represent traits. It could be P-values if the Ps option is TRUE.}

\item{corPhe}{Correlation matirx of phenotypes to be tested; Estimated from Z-scores.}

\item{corSNP}{Correlation matirx of the SNPs to be tested; estimated from a
reference panel (based on the same set of the reference alleles as
used in calculating Z-scores).}

\item{pow1}{SNP specific power(gamma values) used in MTSPUsSetPath test.}

\item{pow2}{GENE specific power(gamma values) used in MTSPUsSetPath test.}

\item{pow3}{Trait specific power(gamma values) used in MTSPUsSetPath test.}

\item{snp.info}{SNP information matrix, the 1st column is SNP id, 2nd column is chromosome #, 3rd column indicates SNP location.}

\item{gene.info}{GENE information matrix, The 1st column is GENE id, 2nd column is chromosome #, 3rd and 4th column indicate start and end positions of the gene.}

\item{n.perm}{number of permutations.}

\item{Ps}{TRUE if input is p-value, FALSE if input is Z-scores. The default is FALSE.}

\item{prune}{if it is TRUE, do pruing before the test using pruneSNP function.}
}
\value{
P-values for MTSPUsSetpath tests and MTaSPUsSetpPath test.
}
\description{
It gives p-values of the MTSPUsSetPath tests and MTaSPUsSetPath test with GWAS summary statistics.
}
\examples{

Zs <- cbind ( c( 0.3, 0.2, 0.1,0.5,1.2),
          c(-.1, .3,-.1,.1,1.2) )

varSNP = cbind( c( 1, .1,0, 0, .11),
               c(.1,1, 0, 0, 0),
               c(0,0, 1, 0, 0),
               c(0,0, 0, 1, 0),
               c(.11,0,0,0,1) )

varPhe = cbind( c( 1, -.1),
               c(-.1,1) )

gene.info = data.frame( Gnm = c( "G1", "G2"), chr = c(1,3),
                    loc1 = c(0, 0), loc2 = c(10,10) )
snp.info = data.frame( rsid = c("rs1", "rs2", "rs3", "rs4", "rs5"),
                chr = c(1,1,3,3,3), loc = c(1,2,1,2,3) )
 out <- MTaSPUsSetPath(Zs, corPhe = varPhe, corSNP=varSNP,
            n.perm = 100, snp.info = snp.info, gene.info = gene.info)
out

}
\author{
Il-Youp Kwak and Wei Pan
}
\references{
Il-Youp Kwak, Wei Pan (2016)
Gene- and pathway-based association tests for multiple
     traits with GWAS summary statistics, Bioinformatics, doi:10.1093/bioinformatics/btw577
}
\seealso{
\code{\link{MTaSPUsSetC}}, \code{\link{MTaSPUsSet}}
}

