% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aSPUsD.R
\name{aSPUsD}
\alias{aSPUsD}
\title{Sum of Powered Score (SPUs) tests and adaptive SPU (aSPUs) test for single trait - SNP set association with GWAS summary statistics (distribution based).}
\usage{
aSPUsD(Zs, corrSNP, Ps = FALSE)
}
\arguments{
\item{Zs}{Z-scores for each SNPs. It could be P-values if the Ps option is TRUE.}

\item{corrSNP}{Correlation matirx of the SNPs to be tested; estimated from a
reference panel (based on the same set of the reference alleles as
used in calculating Z-scores).}

\item{Ps}{TRUE if input is p-value, FALSE if input is Z-scores. The default is FALSE.}
}
\value{
pvs : p-values for the SPUsD and aSPUsD tests.
}
\description{
It gives p-values of the SPUs tests and aSPUs test with GWAS summary statistics.
}
\examples{

data(kegg9)
## example analysis using aSPUM test.
g <- kegg9$gene.info[1,1]  #  SOAT1 
## Take snps mapped on gene "SOAT1" from the information of gene.info and snp.info. 
snps <- which( ( kegg9$snp.info[,2] == kegg9$gene.info[kegg9$gene.info[,1] == g, 2] ) &
                 (kegg9$snp.info[,3] > kegg9$gene.info[kegg9$gene.info[,1] == g, 3] ) &
                 (kegg9$snp.info[,3] < kegg9$gene.info[kegg9$gene.info[,1] == g, 4] )  )
## Take subsets
newP <- kegg9$nP[snps] ;
ldsub <- kegg9$ldmatrix[snps, snps];
## Get p-value for gene SOAT1. Read vignette for details.
out <- aSPUsD(newP, corrSNP=ldsub, Ps=TRUE)

out

}
\author{
Il-Youp Kwak and Wei Pan
}
\references{
Il-Youp Kwak, Wei Pan (2015)
Adaptive Gene- and Pathway-Trait Association Testing with GWAS Summary Statistics,
Bioinformatics, doi: 10.1093/bioinformatics/btv719
}
\seealso{
\code{\link{aSPUs}} \code{\link{aSPU}}
}

