% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multivariate.R
\name{ablasso_mv_ss}
\alias{ablasso_mv_ss}
\title{AB-LASSO Estimator with Random Sample Splitting for Multivariate Models}
\usage{
ablasso_mv_ss(Y, D, C, lag = 1, Kf = 2, nboot = 100, seed = 202302)
}
\arguments{
\item{Y}{A \code{P} x \code{N} (number of time periods x number of individuals) matrix containing the outcome/response variable \code{Y}.}

\item{D}{A \code{P} x \code{N} (number of time periods x number of individuals) matrix containing the policy variable/treatment \code{D}.}

\item{C}{A list of \code{P} x \code{N} matrices containing other treatments and control variables.}

\item{lag}{The lag order of \eqn{Y_{it}} included in the covariates, default is \code{1}.}

\item{Kf}{The number of folds for K-fold cross-validation, with options being \code{2} or \code{5}, default is \code{2}.}

\item{nboot}{The number of random sample splits, default is \code{100}.}

\item{seed}{Seed for random number generation, default \code{202302}.}
}
\value{
A dataframe that includes the estimated coefficients (\eqn{\beta_{j}, \theta_{0}, \theta_{1}}), their standard errors, and T-statistics.
}
\description{
Implements the AB-LASSO estimation method for the multivariate model
\eqn{Y_{it} = \alpha_{i} + \gamma_{t} + \sum_{j=1}^{L} \beta_{j} Y_{i,t-j} + \theta_{0} D_{it} + \theta_{1} C_{i,t-1} + \varepsilon_{it}}, with random sample splitting. Note that \eqn{D_{it}} and \eqn{C_{it}} are predetermined with respect to \eqn{\varepsilon_{it}}.
}
\examples{
\donttest{
# Use the Covid data
N = length(unique(covid_data$fips))
P = length(unique(covid_data$week))
Y = matrix(covid_data$logdc, nrow = P, ncol = N)
D = matrix(covid_data$dlogtests, nrow = P, ncol = N)
C = list()
C[[1]] = matrix(covid_data$school, nrow = P, ncol = N)
C[[2]] = matrix(covid_data$college, nrow = P, ncol = N)
C[[3]] = matrix(covid_data$pmask, nrow = P, ncol = N)
C[[4]] = matrix(covid_data$pshelter, nrow = P, ncol = N)
C[[5]] = matrix(covid_data$pgather50, nrow = P, ncol = N)

results.kf2 <- ablasso_mv_ss(Y = Y, D = D, C = C, lag = 4, nboot = 2)
print(results.kf2)
results.kf5 <- ablasso_mv_ss(Y = Y, D = D, C = C, lag = 4, Kf = 5, nboot = 2)
print(results.kf5)
}
}
