% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export.R
\name{export_abnFit_bayes}
\alias{export_abnFit_bayes}
\title{Export abnFit object fitted with Bayesian methods}
\usage{
export_abnFit_bayes(
  object,
  format,
  include_network,
  scenario_id = NULL,
  label = NULL,
  ...
)
}
\arguments{
\item{object}{An object of class \code{abnFit}, typically created by \code{\link{fitAbn}}.}

\item{format}{Character string specifying the export format. Currently, only
\code{"json"} is supported.}

\item{include_network}{Logical, whether to include network structure (variables
and arcs). Default is \code{TRUE}.}

\item{scenario_id}{Optional character string or numeric identifier for the model
run or scenario. Useful for tracking multiple model versions or experiments.
Default is \code{NULL}.}

\item{label}{Optional character string providing a descriptive name or label
for the scenario. Default is \code{NULL}.}

\item{...}{Additional export options (currently unused, reserved for future extensions).}
}
\value{
A named list with components: scenario_id, label, variables, parameters, arcs.
}
\description{
Export abnFit object fitted with Bayesian methods
}
\details{
This function handles abnFit objects fitted using Bayesian methods.
It will extract the posterior distributions and other Bayesian-specific information.

The structure will follow the same variables/parameters/arcs format, but parameters
will include posterior summaries (mean, median, credible intervals) instead of
point estimates and standard errors.

TODO: Implement the full extraction logic for Bayesian models, including:
\itemize{
\item Posterior mean/median for parameters
\item Credible intervals
\item Convergence diagnostics (Rhat, ESS)
\item Prior specifications
}
}
\keyword{internal}
