% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blocksums.R
\name{blocksums}
\alias{blocksums}
\title{Block Sums}
\usage{
blocksums(x, window, integer = FALSE, max = FALSE)
}
\arguments{
\item{x}{Integer or numeric vector.}

\item{window}{Integer value specifying window length.}

\item{integer}{Logical value for whether \code{x} is an integer vector.}

\item{max}{Logical value for whether to return maximum moving average (as 
opposed to vector of moving averages).}
}
\value{
Numeric value or vector depending on \code{max}.
}
\description{
Calculates block sums (i.e. moving sums but for non-overlapping intervals) or 
maximum block sum. For optimal speed, use \code{integer = TRUE} if \code{x} 
is an integer vector and \code{integer = FALSE} otherwise. If 
\code{length(x)} is not an exact multiple of \code{window}, the last partial 
segment is dropped.
}
\examples{
# Load accelerometer data for first 5 participants in NHANES 2003-2004
data(unidata)

# Get data from ID number 21005, Saturday only
counts.sat <- unidata[unidata[, "seqn"] == 21005 & unidata[, "paxday"] == 7, 
                      "paxinten"]
                      
# Calculate and plot hourly count sums
hourly.sums <- blocksums(x = counts.sat, window = 60, integer = TRUE)
plot(hourly.sums)


}
