% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_dataset.R
\name{prepare_dataset}
\alias{prepare_dataset}
\title{Prepare accelerometer data}
\usage{
prepare_dataset(data)
}
\arguments{
\item{data}{Path to an .agd file that was exported from ActiLife software.}
}
\value{
A dataframe.
}
\description{
This function reads an .agd file and then creates the vector magnitude variable as follows:
\eqn{vm = \sqrt{axis1^{2} + axis2^{2} + axis3^{2}}}.
The .agd file must contain at least the following columns:
\itemize{
\item \strong{axis1}
\item \strong{axis2}
\item \strong{axis3}
\item \strong{steps}
\item \strong{inclineStanding}
\item \strong{inclineSitting}
\item \strong{inclineLying}
\item \strong{inclineOff}
}
}
\examples{
file <- system.file("extdata", "acc.agd", package = "activAnalyzer")
mydata <- prepare_dataset(data = file)
head(mydata)

}
