% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ps_pond_one.R
\name{ps_pond_one}
\alias{ps_pond_one}
\title{weihting on propensity score for one drug exposure}
\usage{
ps_pond_one(
  ps_est,
  y,
  weights_type = c("mw", "iptw"),
  truncation = FALSE,
  q = 0.025
)
}
\arguments{
\item{ps_est}{An object of class \code{"ps", "*"} where \code{"*"} is
\code{"bic"}, \code{"hdps"} or \code{"xgb"} according on how the
score was estimated, respective outputs of internal functions
\code{est_ps_bic}, \code{est_ps_hdps}, \code{est_ps_xgb}.
It is a list with the following elements :
* score_type: character, name of the drug exposure for which the PS was
estimated.
* indicator_expo: indicator of the drugs exposure for which the
PS was estimated. One-column Matrix object.
* score_variables: Character vector, names of covariate(s) selected
to include in the PS estimation model. Could be empty.
*score: One-column Matrix object, the estimated score.}

\item{y}{Binary response variable, numeric.}

\item{weights_type}{Character. Indicates which type of weighting
is implemented. Could be either "mw" or "iptw".}

\item{truncation}{Bouleen, should we do weight truncation?
Default is \code{FALSE}.}

\item{q}{If \code{truncation} is \code{TRUE}, quantile value for
weight truncation. Ignored if \code{truncation} is \code{FALSE}.
Default is 2.5 \eqn{\%}.}
}
\value{
An object with S3 class \code{"ps","*" },
where \code{"*"} is \code{"mw"} or \code{"iptw"}, same as the
input parameter \code{weights_type}
\item{expo_name}{Character, name of the drug exposure for which the PS
was estimated.}
\item{estimate}{Regression coefficient associated with the drug exposure
in adjustment on PS.}
\item{pval_1sided}{One sided p-value associated with the drug exposure
in adjustment on PS.}
\item{pval_2sided}{Two sided p-value associated with the drug exposure
in adjustment on PS.}
Could return NA if the adjustment on the PS did not converge.
}
\description{
Implement the weighting on propensity score with Matching Weights (MW)
or the Inverse Probability of Treatment Weighting (IPTW) for
one drug exposure.
The binary outcome is regressed on the drug exposure of interest
through a classical weighted regression.
Internal function, not supposed to be used directly.
}
\details{
The MW are defined by
\deqn{mw_i = min(PS_i, 1-PS_i)/[(expo_i) * PS_i + (1-expo_i) * (1-PS_i) ] }
and weights from IPTW by
 \deqn{iptw_i = expo_i/PS_i + (1-expo_i)/(1-PS_i)  }
where \eqn{expo_i} is the drug exposure indicator.
The PS could be estimated in different ways: using lasso-bic approach,
the hdPS algorithm or gradient tree boosting using functions
\code{est_ps_bic}, \code{est_ps_hdps} and \code{est_ps_xgb}
respectivelly.
}
\examples{

set.seed(15)
drugs <- matrix(rbinom(100*20, 1, 0.2), nrow = 100, ncol = 20)
colnames(drugs) <- paste0("drugs",1:ncol(drugs))
ae <- rbinom(100, 1, 0.3)
pshdps2 <- est_ps_hdps(idx_expo = 2, x = drugs, y = ae, keep_total = 10)
pondps2 <- ps_pond_one(ps_est = pshdps2, y = ae, weights_type = "iptw")
pondps2$estimate #estimated strength of association between drug_2 and the outcome by PS weighting

}
\author{
Emeline Courtois \cr Maintainer: Emeline Courtois
\email{emeline.courtois@inserm.fr}
}
