% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_trials.R
\name{run_trials}
\alias{run_trials}
\title{Simulate multiple trials}
\usage{
run_trials(
  trial_spec,
  n_rep,
  path = NULL,
  overwrite = FALSE,
  grow = FALSE,
  cores = 1,
  base_seed = NULL,
  sparse = TRUE,
  progress = NULL,
  version = NULL,
  compress = TRUE,
  export = NULL,
  export_envir = parent.frame()
)
}
\arguments{
\item{trial_spec}{\code{trial_spec} object, generated and validated by the
\code{\link[=setup_trial]{setup_trial()}}, \code{\link[=setup_trial_binom]{setup_trial_binom()}} or \code{\link[=setup_trial_norm]{setup_trial_norm()}} function.}

\item{n_rep}{single integer; the number of simulations to run.}

\item{path}{single character; if specified (defaults to \code{NULL}), files will
be written to and  loaded from this path using the \code{\link[=saveRDS]{saveRDS()}} /
\code{\link[=readRDS]{readRDS()}} functions.}

\item{overwrite}{single logical; defaults to \code{FALSE}, in which case previous
simulations saved in the same \code{path} will be re-loaded (if the same trial
specification was used). If \code{TRUE}, the previous file is overwritten. If
\code{grow} is \code{TRUE}, this argument must be set to \code{FALSE}.}

\item{grow}{single logical; defaults to \code{FALSE}. If \code{TRUE} and a valid \code{path}
to a valid previous file containing less simulations than \code{n_rep}, the
additional number of simulations will be run (appropriately re-using the
same \code{base_seed}, if specified) and appended to the same file.}

\item{cores}{single integer; the number of cores to run the simulations on
using the \pkg{parallel} library. Defaults to \code{1}; may be increased to run
multiple simulations in parallel. \code{\link[parallel:detectCores]{parallel::detectCores()}} may be used to
find the number of available cores.}

\item{base_seed}{single integer or \code{NULL} (default); a random seed used as
the basis for simulations. If a number is provided, each single trial
simulation will set the random seed to a value based on this (+ the trial
number), without affecting the global random seed after the function has
been run.}

\item{sparse}{single logical, as described in \code{\link[=run_trial]{run_trial()}}; defaults to
\code{TRUE} when running multiple simulations, in which case only the data
necessary to summarise all simulations are saved for each simulation.
If \code{FALSE}, more detailed data for each simulation is saved, allowing more
detailed printing of individual trial results and plotting using
\code{\link[=plot_history]{plot_history()}} (\code{\link[=plot_status]{plot_status()}} does not require non-sparse results).}

\item{progress}{single numeric \verb{> 0} and \verb{<= 1} or \code{NULL}. If \code{NULL}
(default), no progress is printed to the console. Otherwise, progress
messages are printed to the control at intervals proportional to the value
specified by progress.\cr
\strong{Note:} as printing is not possible from within clusters on multiple
cores, the function conducts batches of simulations on multiple cores (if
specified), with intermittent printing of statuses. Thus, all cores have to
finish running their current assigned batches before the other cores may
proceed with the next batch. If there is substantial differences in the
simulation speeds across cores, using \code{progress} may thus increase total
simulation times.}

\item{version}{passed to \code{\link[=saveRDS]{saveRDS()}} when saving simulations, defaults to
\code{NULL} (as in \code{\link[=saveRDS]{saveRDS()}}), which means that the current default version is
used. Ignored if simulations are not saved.}

\item{compress}{passed to \code{\link[=saveRDS]{saveRDS()}} when saving simulations, defaults to
\code{TRUE} (as in \code{\link[=saveRDS]{saveRDS()}}), see \code{\link[=saveRDS]{saveRDS()}} for other options. Ignored if
simulations are not saved.}

\item{export}{character vector of names of objects to export to each
parallel core if \code{cores > 1}; passed as the \code{varlist} argument to
\code{\link[parallel:clusterApply]{parallel::clusterExport()}}. Defaults to \code{NULL} (no objects exported),
ignored if \code{cores == 1}. See \strong{Details} below.}

\item{export_envir}{\code{environment} where to look for the objects defined
in \code{export} if \code{cores > 1} and \code{export} is not \code{NULL}. Defaults to the
environment from where \code{\link[=run_trials]{run_trials()}} is called.}
}
\value{
A list of a special class \code{"trial_results"}, which contains the
\code{trial_results} (results from all simulations), \code{trial_spec} (the trial
specification), \code{n_rep}, \code{base_seed}, \code{elapsed_time} (the total simulation
run time), \code{sparse} (as described above) and \code{adaptr_version} (the version
of the \code{adaptr} package used to run the simulations). These results may be
extracted using the \code{\link[=extract_results]{extract_results()}} function and summarised using the
\code{\link[=summary]{summary()}} or print (\code{\link[=print.trial_results]{print.trial_results()}}) functions; see function
documentation for details on additional arguments used to select arms in
simulations not ending in superiority and other summary choices.
}
\description{
This function conducts multiple simulations using a trial specification as
specified by \code{\link[=setup_trial]{setup_trial()}}, \code{\link[=setup_trial_binom]{setup_trial_binom()}} or \code{\link[=setup_trial_norm]{setup_trial_norm()}}.
This function essentially manages random seeds and runs multiple simulation
using \code{\link[=run_trial]{run_trial()}} - additional details on individual simulations are
provided in that function's description. This function allows simulating
trials in parallel using multiple cores, automatically saving and re-loading
saved objects, and "growing" already saved simulation files (i.e., appending
additional simulations to the same file).
}
\details{
\strong{Exporting objects when using multiple cores}

If \code{\link[=setup_trial]{setup_trial()}} is used to define a trial specification with custom
functions (in the \code{fun_y_gen}, \code{fun_draws}, and \code{fun_raw_est} arguments of
\code{\link[=setup_trial]{setup_trial()}}) and \code{\link[=run_trials]{run_trials()}} is run with \code{cores > 1}, it is necessary
to export additional functions or objects used by these functions and defined
by the user outside the function definitions provided. Similarly, functions
from external packages loaded using \code{\link[=library]{library()}} or \code{\link[=require]{require()}} must be
exported or called prefixed with the namespace, i.e., \verb{package::function}.
The \code{export} and \code{export_envir} arguments are used to export objects calling
the \code{\link[parallel:clusterApply]{parallel::clusterExport()}}-function.
}
\examples{
# Setup a trial specification
binom_trial <- setup_trial_binom(arms = c("A", "B", "C", "D"),
                                 true_ys = c(0.20, 0.18, 0.22, 0.24),
                                 data_looks = 1:20 * 100)

# Run 10 simulations with a specified random base seed
res <- run_trials(binom_trial, n_rep = 10, base_seed = 12345)

# See ?summary and ?print for details on summarising and printing

}
