% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/import.R
\name{import2genind}
\alias{import2genind}
\title{Importing data from several softwares to a genind object}
\usage{
import2genind(file, quiet = FALSE, ...)
}
\arguments{
\item{file}{a character string giving the path to the file to convert, with
the appropriate extension.}

\item{quiet}{logical stating whether a conversion message must be printed
(TRUE,default) or not (FALSE).}

\item{\dots}{other arguments passed to the appropriate 'read' function
(currently passed to \code{read.structure})}
}
\value{
an object of the class \code{genind}
}
\description{
Their are several ways to import genotype data to a \linkS4class{genind}
object: i) from a data.frame with a given format (see
\code{\link{df2genind}}), ii) from a file with a recognized extension, or
iii) from an alignement of sequences (see \code{\link{DNAbin2genind}}).\cr
}
\details{
The function \code{import2genind} detects the extension of the file given in
argument and seeks for an appropriate import function to create a
\code{genind} object.\cr Current recognized formats are :\cr - GENETIX files
(.gtx) \cr - Genepop files (.gen) \cr - Fstat files (.dat) \cr - STRUCTURE
files (.str or .stru) \cr

Beware: same data in different formats are not expected to produce exactly
the same \code{genind} objects.\cr For instance, conversions made by GENETIX
to Fstat may change the the sorting of the genotypes; GENETIX stores
individual names whereas Fstat does not; Genepop chooses a sample's name
from the name of its last genotype; etc.
}
\examples{
import2genind(system.file("files/nancycats.gtx",
package="adegenet"))

import2genind(system.file("files/nancycats.dat",
package="adegenet"))

import2genind(system.file("files/nancycats.gen",
package="adegenet"))

import2genind(system.file("files/nancycats.str",
package="adegenet"), onerowperind=FALSE, n.ind=237, n.loc=9, col.lab=1, col.pop=2, ask=FALSE)
}
\author{
Thibaut Jombart \email{t.jombart@imperial.ac.uk}
}
\references{
Belkhir K., Borsa P., Chikhi L., Raufaste N. & Bonhomme F.
(1996-2004) GENETIX 4.05, logiciel sous Windows TM pour la genetique des
populations. Laboratoire Genome, Populations, Interactions, CNRS UMR 5000,
Universite de Montpellier II, Montpellier (France). \cr

Pritchard, J.; Stephens, M. & Donnelly, P. (2000) Inference of population
structure using multilocus genotype data. \emph{Genetics}, \bold{155}:
945-959

Raymond M. & Rousset F, (1995). GENEPOP (version 1.2): population genetics
software for exact tests and ecumenicism. \emph{J. Heredity},
\bold{86}:248-249 \cr

Fstat (version 2.9.3). Software by Jerome Goudet.
http://www2.unil.ch/popgen/softwares/fstat.htm\cr

Excoffier L. & Heckel G.(2006) Computer programs for population genetics
data analysis: a survival guide \emph{Nature}, \bold{7}: 745-758
}
\seealso{
\code{\link{import2genind}}, \code{\link{read.genetix}},
\code{\link{read.fstat}}, \code{\link{read.structure}},
\code{\link{read.genepop}}
}
\keyword{manip}

