% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Hs.R
\name{Hs}
\alias{Hs}
\title{Expected heterozygosity (Hs)}
\usage{
Hs(x, pop = NULL)
}
\arguments{
\item{x}{a \linkS4class{genind} or \linkS4class{genpop} object.}

\item{pop}{only used if x is a \linkS4class{genind}; an optional factor to be used as population; if not provided, pop(x) is used.}
}
\value{
a vector of Hs values (one value per population)
}
\description{
This function computes the expected heterozygosity (Hs) within
populations of a \linkS4class{genpop} object. This function is
available for codominant markers (\code{@type="codom"}) only. Hs is
commonly used for measuring within population genetic diversity (and
as such, it still has sense when computed from haploid data).
}
\details{
Let \emph{m(k)} be the number of alleles of locus \emph{k}, with a
total of \emph{K} loci. We note \eqn{f_i} the allele frequency of
allele \emph{i} in a given population. Then, \eqn{Hs} is given for a
given population by:\cr

\eqn{\frac{1}{K} \sum_{k=1}^K (1 - \sum_{i=1}^{m(k)} f_i^2)}
}
\examples{
\dontrun{
data(nancycats)
Hs(genind2genpop(nancycats))
}

}
\author{
Thibaut Jombart \email{t.jombart@imperial.ac.uk}
}
\seealso{
\code{\link{Hs.test}} to test differences in Hs between two groups
}

