% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connect_adf.R
\name{connect_adf}
\alias{connect_adf}
\title{Create a connection to a virtual disk}
\usage{
connect_adf(filename, write_protected = TRUE)
}
\arguments{
\item{filename}{Filename of the \code{ADF} or \code{ADZ} file containing the virtual disk}

\item{write_protected}{A \code{logical} value indicating whether the
virtual disk needs to be write protected. If \code{TRUE}, you can only open
'read only' connections and cannot write to the disk.}
}
\value{
Returns an R connection of class \code{adf_device}.
}
\description{
Establish a connection to a virtual disk stored as Amiga Disk Files (ADF).
You cannot write or read directly from this connection. Instead, use the
methods provided in this package to retrieve information about the virtual
disk or create connections to the files on the disk, to which you \emph{can}
write and read from (see \code{\link[=adf_file_con]{adf_file_con()}}). Like any other connection,
please use \code{\link[=close]{close()}} to close the connection after use.
}
\examples{
adz_file <- system.file("example.adz", package = "adfExplorer")
my_device <- connect_adf(adz_file)

device_capacity(my_device)
close(my_device)
}
\author{
Pepijn de Vries
}
