% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/snpClust.R
\name{snpClust}
\alias{snpClust}
\title{Adjacency-constrained Clustering of Single Nucleotide Polymorphisms}
\usage{
snpClust(x, h = ncol(x) - 1, ...)
}
\arguments{
\item{x}{either a genotype matrix of class snpStats::SnpMatrix/base::matrix 
or a linkage disequilibrium matrix of class Matrix::dgCMatrix}

\item{h}{band width. If not provided, \code{h} is set to default value `p-1` 
where `p` is the number of columns of `x`}

\item{\dots}{Further arguments to be passed to the \code{snpStats::ld} 
function}
}
\value{
An object of class \code{\link{chac}} (when no LD value is missing)
}
\description{
Adjacency-constrained hierarchical agglomerative clustering of Single 
Nucleotide Polymorphisms based on Linkage Disequilibrium
}
\details{
Adjacency-constrained hierarchical agglomerative clustering (HAC) is HAC in 
which each observation is associated to a position, and the clustering is 
constrained so as only adjacent clusters are merged. SNPs are clustered based
on their similarity as measured by the linkage disequilibrium.

In the special case where genotypes are given as input and the corresponding
LD matrix has missing entries, the clustering cannot be performed. This can
typically happen when there is insufficient variability in the sample
genotypes. In this special case, the indices of the SNP pairs which yield
missing values are returned
}
\examples{
## a very small example
data(testdata, package = "snpStats")

# input as snpStats::SnpMatrix
fit1 <- snpClust(Autosomes[1:200, 1:5], h = 3, stats = "R.squared")

# input as base::matrix
fit2 <- snpClust(as.matrix(Autosomes[1:200, 1:5]), h = 3, stats = "R.squared")

# input as Matrix::dgCMatrix
ld <- snpStats::ld(Autosomes[1:200, 1:5], depth = 3, stats = "R.squared")
fit3 <- snpClust(ld, 3)

}
\references{
Dehman A. (2015) \emph{Spatial Clustering of Linkage 
  Disequilibrium Blocks for Genome-Wide Association Studies}, PhD thesis, 
  Universite Paris Saclay.

Dehman, A. Ambroise, C. and Neuvial, P. (2015). Performance of a 
  blockwise approach in variable selection using linkage disequilibrium 
  information. *BMC Bioinformatics* 16:148.
}
\seealso{
\code{\link{adjClust}} \code{\link[snpStats:ld]{ld}}
}
