% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_param_extreme_event.R
\name{derive_param_extreme_event}
\alias{derive_param_extreme_event}
\title{Add an Extreme Event Parameter}
\usage{
derive_param_extreme_event(
  dataset = NULL,
  dataset_adsl,
  dataset_source,
  filter_source,
  order = NULL,
  new_var = NULL,
  true_value = "Y",
  false_value = "N",
  mode = "first",
  subject_keys = get_admiral_option("subject_keys"),
  set_values_to,
  check_type = "warning"
)
}
\arguments{
\item{dataset}{Input dataset

The \code{PARAMCD} variable is expected.}

\item{dataset_adsl}{ADSL input dataset

The variables specified for \code{subject_keys} are expected. For each
observation of the specified dataset a new observation is added to the
input dataset.}

\item{dataset_source}{Source dataset

All observations in the specified dataset fulfilling the condition
specified by \code{filter_source} are considered as an event.

The variables specified by the \code{subject_keys} and
\code{order} argument (if applicable) are expected.}

\item{filter_source}{Source filter

All observations in \code{dataset_source} fulfilling the specified condition are
considered as an event.

For subjects with at least one event \code{new_var} is set to \code{true_value}.

For all other subjects \code{new_var} is set to \code{false_value}.}

\item{order}{Order variable

List of symbols for sorting the source dataset (\code{dataset_source}).

\emph{Permitted Values}: list of expressions created by \code{exprs()}, e.g.,
\code{exprs(ADT, desc(AVAL))}.}

\item{new_var}{New variable

The name of the variable which will indicate whether an event happened or not.}

\item{true_value}{True value

For all subjects with at least one observation in the source dataset
(\code{dataset_source}) fulfilling the event condition (\code{filter_source}),
\code{new_var} is set to the specified value \code{true_value}.}

\item{false_value}{False value

For all other subjects in \code{dataset_adsl} without an event, \code{new_var} is set to
the specified value \code{false_value}.}

\item{mode}{Selection mode (first or last)

If \code{"first"} is specified, the first observation of each subject is selected.
If \code{"last"} is specified, the last observation of each subject is selected.

\emph{Permitted Values}: \code{"first"}, \code{"last"}}

\item{subject_keys}{Variables to uniquely identify a subject

A list of symbols created using \code{exprs()} is expected.}

\item{set_values_to}{Variables to set

A named list returned by \code{exprs()} defining the variables to be set for the
new parameter, e.g. \code{exprs(PARAMCD = "PD", PARAM = "Disease Progression")}
is expected. The values must be symbols, character strings, numeric values,
\code{NA}, or an expression. Note, if you require a date or datetime variable to
be populated, this needs to be defined here.}

\item{check_type}{Check uniqueness?

If \code{"warning"} or \code{"error"} is specified, a message is issued if the
observations of the source dataset (\code{dataset_source}) restricted by
\code{filter_source} are not unique with respect to the subject keys
(\code{subject_key} argument) and \code{order}.

\emph{Permitted Values}: \code{"none"}, \code{"warning"}, \code{"error"}}
}
\value{
The input dataset with a new parameter indicating if and when an
event occurred
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

This function is \emph{deprecated}, please use \code{derive_extreme_records()} instead.

Add a new parameter for the first or last event occurring in a dataset. The
variable given in \code{new_var} indicates if an event occurred or not. For
example, the function can derive a parameter for the first disease
progression.
}
\details{
\enumerate{
\item The source dataset (\code{dataset_source}) is restricted to observations fulfilling
\code{filter_source}.
\item For each subject (with respect to the variables specified for the
\code{subject_keys} argument) either the first or last observation from the restricted
source dataset is selected. This is depending on \code{mode}, (with respect to \code{order},
if applicable) where the event condition (\code{filter_source} argument) is fulfilled.
\item For each observation in \code{dataset_adsl} a new observation is created. For
subjects with event \code{new_var} is set to \code{true_value}. For all other
subjects \code{new_var} is set to \code{false_value}.
For subjects with event all variables from \code{dataset_source} are kept. For
subjects without event all variables which are in both \code{dataset_adsl} and
\code{dataset_source} are kept.
\item The variables specified by the \code{set_values_to} argument are added to
the new observations.
\item The new observations are added to input dataset.
}
}
\seealso{
Other deprecated: 
\code{\link{derive_var_basetype}()},
\code{\link{derive_var_confirmation_flag}()},
\code{\link{derive_var_disposition_status}()},
\code{\link{derive_var_last_dose_amt}()},
\code{\link{derive_var_last_dose_date}()},
\code{\link{derive_var_last_dose_grp}()},
\code{\link{derive_var_merged_cat}()},
\code{\link{derive_var_merged_character}()},
\code{\link{derive_var_worst_flag}()},
\code{\link{derive_vars_disposition_reason}()},
\code{\link{derive_vars_last_dose}()},
\code{\link{format_eoxxstt_default}()},
\code{\link{format_reason_default}()}
}
\concept{deprecated}
\keyword{deprecated}
