% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_vars_query.R
\name{assert_valid_queries}
\alias{assert_valid_queries}
\title{Verify if a Dataset Has the Required Format as Queries Dataset.}
\usage{
assert_valid_queries(queries, queries_name)
}
\arguments{
\item{queries}{A data.frame.}

\item{queries_name}{Name of the queries dataset, a string.}
}
\value{
The function throws an error if any of the requirements not met.
}
\description{
Verify if a Dataset Has the Required Format as Queries Dataset.
}
\details{
Check if the dataset has the following columns
\itemize{
\item \code{PREFIX}, e.g., SMQ01, CQ12
\item \code{GRPNAME}, non NA, must be unique per each \code{PREFIX}
\item \code{GRPID}, could be NA, must be unique per each \code{PREFIX}
\item \code{SCOPE}, 'BROAD', 'NARROW', or NA
\item \code{SCOPEN}, 1, 2, or NA
\item \code{SRCVAR}, e.g., \code{"AEDECOD"}, \code{"AELLT"}, \code{"AELLTCD"}, ...
\item \code{TERMNAME}, character, could be NA only at those observations
where \code{TERMID} is non-NA
\item \code{TERMID}, integer, could be NA only at those observations
where \code{TERMNAME} is non-NA
}
}
\examples{
data("queries")
assert_valid_queries(queries, "queries")
}
\seealso{
Other Advanced Functions: 
\code{\link{assert_db_requirements}()},
\code{\link{assert_parameters_argument}()},
\code{\link{assert_terms}()},
\code{\link{extend_source_datasets}()},
\code{\link{filter_date_sources}()},
\code{\link{format.basket_select}()},
\code{\link{get_hori_data}()},
\code{\link{list_tte_source_objects}()},
\code{\link{params}()},
\code{\link{validate_basket_select}()},
\code{\link{validate_query}()}
}
\concept{other_advanced}
\keyword{other_advanced}
