% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_var_aendy.R
\name{derive_var_aendy}
\alias{derive_var_aendy}
\title{Derive Analysis End Relative Day}
\usage{
derive_var_aendy(dataset, reference_date = TRTSDT, date = AENDT)
}
\arguments{
\item{dataset}{Input dataset

The columns specified by the \code{reference_date} and the \code{date} parameter are
expected.}

\item{reference_date}{The start date column, e.g., date of first treatment

A date or date-time object column is expected.

The default is \code{TRTSDT}.}

\item{date}{The end date column for which the study day should be derived

A date or date-time object column is expected.

The default is \code{AENDT}}
}
\value{
The input dataset with \code{AENDY} column added
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#questioning}{\figure{lifecycle-questioning.svg}{options: alt='[Questioning]'}}}{\strong{[Questioning]}}

Adds the analysis end relative day (\code{AENDY}) to the dataset, i.e. study day
of analysis end date
}
\details{
The study day is derived as number of days from the start date
to the end date. If it is nonnegative, one is added. I.e., the study day of the
start date is 1.
}
\examples{
data <- tibble::tribble(
  ~TRTSDT, ~AENDT,
  lubridate::ymd("2020-01-01"), lubridate::ymd("2020-02-24")
)

derive_var_aendy(data)
}
\author{
Stefan Bundfuss
}
\keyword{bds}
\keyword{derivation}
\keyword{occds}
\keyword{timing}
