% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_var_obs_number.R
\name{derive_var_obs_number}
\alias{derive_var_obs_number}
\title{Adds a Variable Numbering the Observations Within Each By Group}
\usage{
derive_var_obs_number(
  dataset,
  by_vars = NULL,
  order = NULL,
  new_var = ASEQ,
  check_type = "none"
)
}
\arguments{
\item{dataset}{Input dataset

The variables specified by the \code{order} and the \code{by_vars} parameter are
expected.}

\item{by_vars}{Grouping variables

Permitted Values: list of variables}

\item{order}{Sort order

Within each by group the observations are ordered by the specified order.

Permitted Values: list of variables or functions of variables}

\item{new_var}{Name of variable to create

The new variable is set to the observation number for each by group. The
numbering starts with 1.

Default: \code{ASEQ}}

\item{check_type}{Check uniqueness?

If \code{"warning"} or \code{"error"} is specified, the specified message is issued
if the observations of the input dataset are not unique with respect to the
by variables and the order.

Default: \code{"none"}

Permitted Values: \code{"none"}, \code{"warning"}, \code{"error"}}
}
\value{
A dataset containing all observations and variables of the input
dataset and additionally the variable specified by the \code{new_var} parameter.
}
\description{
Adds a variable numbering the observations within each by group
}
\details{
For each group (with respect to the variables specified for the
\code{by_vars} parameter) the first or last observation (with respect to the
order specified for the \code{order} parameter and the mode specified for the
\code{mode} parameter) is included in the output dataset.
}
\examples{
library(dplyr, warn.conflicts = FALSE)
library(admiral.test)
data("vs")

vs \%>\%
  select(USUBJID, VSTESTCD, VISITNUM, VSTPTNUM) \%>\%
  filter(VSTESTCD \%in\% c("HEIGHT", "WEIGHT")) \%>\%
  derive_var_obs_number(
    by_vars = vars(USUBJID, VSTESTCD),
    order = vars(VISITNUM, VSTPTNUM)
  )
}
\author{
Stefan Bundfuss
}
\keyword{adam}
\keyword{derivation}
