% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_vars_suppqual.R
\name{derive_vars_suppqual}
\alias{derive_vars_suppqual}
\title{Join Supplementary Qualifier Variables into the Parent SDTM Domain}
\usage{
derive_vars_suppqual(dataset, dataset_suppqual, domain = NULL)
}
\arguments{
\item{dataset}{A SDTM domain data set.}

\item{dataset_suppqual}{A Supplemental Qualifier (SUPPQUAL) data set.}

\item{domain}{Two letter domain value. Used when supplemental data set is
common across multiple SDTM domain.}
}
\value{
A data frame with SUPPQUAL variables appended to parent data set.
}
\description{
The SDTM does not allow any new variables beside ones assigned to each SDTM
domain. So, Supplemental Qualifier is introduced to supplement each SDTM
domain to contain non standard variables. \code{dataset_suppqual} can be either
a single SUPPQUAL dataset or separate supplementary data sets (SUPP) such
as SUPPDM, SUPPAE, and SUPPEX. When a \code{dataset_suppqual} is a single SUPPQUAL
dataset, specify two character\code{domain} value.
}
\details{
\code{derive_vars_suppqual()} expects \code{USUBJID}, \code{RDOMAIN}, \code{IDVAR}, \code{IDVARVAL},
\code{QNAM}, \code{QLABEL}, and \code{QVAL} variables to exist in \code{dataset_suppqual}.
}
\examples{
## The following example includes selected variables from AE and SUPPAE
## datasets for a rash whose locations are the face, neck, and chest.
ae <- tibble::tribble(
  ~STUDYID,   ~DOMAIN, ~USUBJID,   ~AESEQ, ~AETERM,  ~AELOC,
  "1234-005", "AE",    "XYZ-1001",      1, "RASH",  "MULTIPLE",
  "1234-005", "AE",    "XYZ-1002",      1, "NAUSEA", "",
)
suppae <- tibble::tribble(
  ~STUDYID,   ~RDOMAIN, ~USUBJID,    ~IDVAR,  ~IDVARVAL, ~QNAM,     ~QLABEL,     ~QVAL,
  "1234-005", "AE",     "XYZ-1001", "AESEQ", "1",        "AELOC1", "Location 1", "FACE",
  "1234-005", "AE",     "XYZ-1001", "AESEQ", "1",        "AELOC2", "Location 2", "NECK",
  "1234-005", "AE",     "XYZ-1001", "AESEQ", "1",        "AELOC3", "Location 3", "CHEST",
)
derive_vars_suppqual(ae, suppae)

## The following example included subjects with multiple/other specific race.
dm <- tibble::tribble(
  ~STUDYID, ~DOMAIN, ~USUBJID, ~RACE,
  "ABC",    "DM",    "001",    "OTHER",
  "ABC",    "DM",    "002",    "MULTIPLE",
  "ABC",    "DM",    "003",    NA,
  "ABC",    "DM",    "004",    "ASIAN"
)
suppdm <- tibble::tribble(
  ~STUDYID, ~RDOMAIN, ~USUBJID, ~IDVAR, ~IDVARVAL, ~QNAM,     ~QLABEL,       ~QVAL,
  "ABC",   "DM",      "001",     "",     "",       "RACEOTH", "Race, Other", "BRAZILIAN",
  "ABC",   "DM",      "002",     "",     "",       "RACE1"  , "Race 1",      "AMERICAN",
  "ABC",   "DM",      "002",     "",     "",       "RACE2"  , "Race 2",      "OTHER",
  "ABC",   "DM",      "002",     "",     "",       "RACEOTH", "Race, Other", "ABORIGINE"
)
derive_vars_suppqual(dm, suppdm)
}
\author{
Vignesh Thanikachalam
}
