% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_var_lstalvdt.R
\name{lstalvdt_source}
\alias{lstalvdt_source}
\title{Create an \code{lstalvdt_source} object}
\usage{
lstalvdt_source(
  dataset_name,
  filter = NULL,
  date,
  date_imputation = NULL,
  preserve = FALSE,
  traceability_vars = NULL,
  dataset = deprecated()
)
}
\arguments{
\item{dataset_name}{The name of the dataset, i.e. a string, used to search for
the last known alive date.}

\item{filter}{An unquoted condition for filtering \code{dataset}.}

\item{date}{A variable providing a date where the patient was known to be
alive. A date, a datetime, or a character variable containing ISO 8601
dates can be specified. An unquoted symbol is expected.}

\item{date_imputation}{A string defining the date imputation for \code{date}.
See \code{date_imputation} parameter of \code{impute_dtc()} for valid values.}

\item{preserve}{Preserve day if month is missing and day is present

For example \code{"2019---07"} would return \verb{"2019-06-07} if \code{preserve = TRUE}
(and \code{date_imputation = "MID"}).

Permitted Values: \code{TRUE}, \code{FALSE}

Default: \code{FALSE}}

\item{traceability_vars}{A named list returned by \code{vars()} defining the
traceability variables, e.g. \code{vars(LALVDOM = "AE", LALVSEQ = AESEQ, LALVVAR = "AESTDTC")}. The values must be a symbol, a character string, or \code{NA}.}

\item{dataset}{Deprecated, please use \code{dataset_name} instead.}
}
\value{
An object of class "lstalvdt_source".
}
\description{
Create an \code{lstalvdt_source} object
}
\author{
Stefan Bundfuss
}
\keyword{source_specifications}
