% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/user_utils.R
\name{filter_if}
\alias{filter_if}
\title{Optional Filter}
\usage{
filter_if(dataset, filter)
}
\arguments{
\item{dataset}{Input dataset}

\item{filter}{A filter condition. Must be a quosure.}
}
\value{
A \code{data.frame} containing all rows in \code{dataset} matching \code{filter} or
just \code{dataset} if \code{filter} is \code{NULL}
}
\description{
Filters the input dataset if the provided expression is not \code{NULL}
}
\examples{
library(admiral.test)
data(admiral_vs)

admiral::filter_if(admiral_vs, rlang::quo(NULL))
admiral::filter_if(admiral_vs, rlang::quo(VSTESTCD == "WEIGHT"))
}
\author{
Thomas Neitmann
}
\keyword{user_utility}
