% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_vars_computed.R
\name{derive_vars_computed}
\alias{derive_vars_computed}
\title{Adds Variable(s) Computed from the Analysis Value of one or more Parameters}
\usage{
derive_vars_computed(
  dataset,
  dataset_add,
  by_vars,
  parameters,
  new_vars,
  filter_add = NULL,
  constant_by_vars = NULL,
  constant_parameters = NULL
)
}
\arguments{
\item{dataset}{The variables specified by the \code{by_vars} parameter are expected.}

\item{dataset_add}{Additional dataset

The variables specified by the \code{by_vars} parameter are expected.

The variable specified by \code{by_vars} and \code{PARAMCD} must be a unique key of
the additional dataset after restricting it by the filter condition
(\code{filter_add} parameter) and to the parameters specified by \code{parameters}.}

\item{by_vars}{Grouping variables

Grouping variables uniquely identifying a set of records for which
\code{new_vars} are to be calculated.

\emph{Permitted Values:} list of variables created by exprs()}

\item{parameters}{Required parameter codes

It is expected that all parameter codes (\code{PARAMCD}) which are required to
derive the new variable are specified for this parameter or the
\code{constant_parameters} parameter.

If observations should be considered which do not have a parameter code,
e.g., if an SDTM dataset is used, temporary parameter codes can be derived
by specifying a list of expressions. The name of the element defines the
temporary parameter code and the expression defines the condition for
selecting the records. For example,
\code{parameters = exprs(HGHT = VSTESTCD == "HEIGHT")} selects the observations
with \code{VSTESTCD == "HEIGHT"} from the input data (\code{dataset} and
\code{dataset_add}), sets \code{PARAMCD = "HGHT"} for these observations, and adds
them to the observations to consider.

Unnamed elements in the list of expressions are considered as parameter
codes. For example, \code{parameters = exprs(WEIGHT, HGHT = VSTESTCD == "HEIGHT")} uses the parameter code \code{"WEIGHT"} and creates a temporary
parameter code \code{"HGHT"}.

\emph{Permitted Values:} A character vector of \code{PARAMCD} values or a list of expressions}

\item{new_vars}{Name of the newly created variables

The specified variables are set to the specified values. The values of
variables of the parameters specified by \code{parameters} can be accessed using
\verb{<variable name>.<parameter code>}. For example

\if{html}{\out{<div class="sourceCode">}}\preformatted{exprs(
  BMIBL = (AVAL.WEIGHT / (AVAL.HEIGHT/100)^2)
)
}\if{html}{\out{</div>}}

defines the value for the new variable.

Variable names in the expression must not contain more than one dot.

\emph{Permitted Values:} List of variable-value pairs}

\item{filter_add}{Filter condition of additional dataset

The specified condition is applied to the additional dataset before
deriving the new variable, i.e., only observations fulfilling the
condition are taken into account.

\emph{Permitted Values:} a condition}

\item{constant_by_vars}{By variables for constant parameters

The constant parameters (parameters that are measured only once) are merged
to the other parameters using the specified variables.
(Refer to the Example)

\emph{Permitted Values:} list of variables}

\item{constant_parameters}{Required constant parameter codes

It is expected that all the parameter codes (\code{PARAMCD}) which are required
to derive the new variable and are measured only once are specified here.
For example if BMI should be derived and height is measured only once while
weight is measured at each visit. Height could be specified in the
\code{constant_parameters} parameter. (Refer to the Example)

If observations should be considered which do not have a parameter code,
e.g., if an SDTM dataset is used, temporary parameter codes can be derived
by specifying a list of expressions. The name of the element defines the
temporary parameter code and the expression defines the condition for
selecting the records. For example \code{constant_parameters = exprs(HGHT = VSTESTCD == "HEIGHT")} selects the observations with
\code{VSTESTCD == "HEIGHT"} from the input data (\code{dataset} and \code{dataset_add}),
sets \code{PARAMCD = "HGHT"} for these observations, and adds them to the
observations to consider.

Unnamed elements in the list of expressions are considered as parameter
codes. For example, \code{constant_parameters = exprs(WEIGHT, HGHT = VSTESTCD == "HEIGHT")} uses the parameter code \code{"WEIGHT"} and creates a temporary
parameter code \code{"HGHT"}.

\emph{Permitted Values:} A character vector of \code{PARAMCD} values or a list of expressions}
}
\value{
The input dataset with the new variables added.
}
\description{
Adds Variable(s) computed from the analysis value of one or more parameters.
It is expected that the value of the new variable is defined by an expression
using the analysis values of other parameters. For example Body Mass Index at
Baseline (\code{BMIBL}) in \code{ADSL} can be derived from of HEIGHT and WEIGHT
parameters in \code{ADVS}.
}
\details{
For each group (with respect to the variables specified for the
\code{by_vars} argument), the values of the new variables (\code{new_vars}) are
computed based on the parameters in the additional dataset
(\code{dataset_add}) and then the new variables are merged to the input
dataset (\code{dataset}).
}
\examples{
library(tibble)
library(dplyr)

# Example 1: Derive BMIBL
adsl <- tribble(
  ~STUDYID,   ~USUBJID, ~AGE,   ~AGEU,
  "PILOT01", "01-1302",   61, "YEARS",
  "PILOT01", "17-1344",   64, "YEARS"
)

advs <- tribble(
  ~STUDYID, ~USUBJID, ~PARAMCD, ~PARAM, ~VISIT, ~AVAL, ~AVALU, ~ABLFL,
  "PILOT01", "01-1302", "HEIGHT", "Height (cm)", "SCREENING", 177.8, "cm", "Y",
  "PILOT01", "01-1302", "WEIGHT", "Weight (kg)", "SCREENING", 81.19, "kg", "N",
  "PILOT01", "01-1302", "WEIGHT", "Weight (kg)", "BASELINE", 82.1, "kg", "Y",
  "PILOT01", "01-1302", "WEIGHT", "Weight (kg)", "WEEK 2", 81.19, "kg", "N",
  "PILOT01", "01-1302", "WEIGHT", "Weight (kg)", "WEEK 4", 82.56, "kg", "N",
  "PILOT01", "01-1302", "WEIGHT", "Weight (kg)", "WEEK 6", 80.74, "kg", "N",
  "PILOT01", "17-1344", "HEIGHT", "Height (cm)", "SCREENING", 163.5, "cm", "Y",
  "PILOT01", "17-1344", "WEIGHT", "Weight (kg)", "SCREENING", 58.06, "kg", "N",
  "PILOT01", "17-1344", "WEIGHT", "Weight (kg)", "BASELINE", 58.06, "kg", "Y",
  "PILOT01", "17-1344", "WEIGHT", "Weight (kg)", "WEEK 2", 58.97, "kg", "N",
  "PILOT01", "17-1344", "WEIGHT", "Weight (kg)", "WEEK 4", 57.97, "kg", "N",
  "PILOT01", "17-1344", "WEIGHT", "Weight (kg)", "WEEK 6", 58.97, "kg", "N"
)

derive_vars_computed(
  dataset = adsl,
  dataset_add = advs,
  by_vars = exprs(STUDYID, USUBJID),
  parameters = c("WEIGHT", "HEIGHT"),
  new_vars = exprs(BMIBL = compute_bmi(height = AVAL.HEIGHT, weight = AVAL.WEIGHT)),
  filter_add = ABLFL == "Y"
)
}
\seealso{
General Derivation Functions for all ADaMs that returns variable appended to dataset:
\code{\link{derive_var_extreme_flag}()},
\code{\link{derive_var_joined_exist_flag}()},
\code{\link{derive_var_merged_ef_msrc}()},
\code{\link{derive_var_merged_exist_flag}()},
\code{\link{derive_var_merged_summary}()},
\code{\link{derive_var_obs_number}()},
\code{\link{derive_var_relative_flag}()},
\code{\link{derive_vars_joined}()},
\code{\link{derive_vars_merged}()},
\code{\link{derive_vars_merged_lookup}()},
\code{\link{derive_vars_transposed}()}
}
\concept{der_gen}
\keyword{der_gen}
