% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_framingham.R
\name{compute_framingham}
\alias{compute_framingham}
\title{Compute Framingham Heart Study Cardiovascular Disease 10-Year Risk Score}
\usage{
compute_framingham(sysbp, chol, cholhdl, age, sex, smokefl, diabetfl, trthypfl)
}
\arguments{
\item{sysbp}{Systolic blood pressure

A numeric vector is expected.}

\item{chol}{Total serum cholesterol (mg/dL)

A numeric vector is expected.}

\item{cholhdl}{HDL serum cholesterol (mg/dL)

A numeric vector is expected.}

\item{age}{Age (years)

A numeric vector is expected.}

\item{sex}{Gender

A character vector is expected.
Expected Values: 'M' 'F'}

\item{smokefl}{Smoking Status

A character vector  is expected.
Expected Values: 'Y' 'N'}

\item{diabetfl}{Diabetic Status

A character vector is expected.
Expected Values: 'Y' 'N'}

\item{trthypfl}{Treated for hypertension status

A character vector is expected.
Expected Values: 'Y' 'N'}
}
\value{
A numeric vector of Framingham values
}
\description{
Computes Framingham Heart Study Cardiovascular Disease 10-Year Risk Score
(FCVD101) based on systolic blood pressure, total serum cholesterol (mg/dL),
HDL serum cholesterol (mg/dL), sex, smoking status, diabetic status,
and treated for hypertension flag.
}
\details{
The predicted probability of having cardiovascular disease (CVD)
within 10-years according to Framingham formula.  See AHA Journal article
General Cardiovascular Risk Profile for Use in Primary Care for reference.

\strong{For Women:}

\tabular{rr}{
\strong{Factor} \tab \strong{Amount} \cr
Age \tab 2.32888 \cr
Total Chol \tab 1.20904 \cr
HDL Chol \tab -0.70833 \cr
Sys BP \tab 2.76157 \cr
Sys BP + Hypertension Meds \tab 2.82263 \cr
Smoker \tab 0.52873 \cr
Non-Smoker \tab 0 \cr
Diabetic \tab 0.69154 \cr
Not Diabetic \tab 0 \cr
Average Risk \tab 26.1931 \cr
Risk Period \tab 0.95012 \cr
}

\strong{For Men:}

\tabular{rr}{
\strong{Factor} \tab \strong{Amount} \cr
Age \tab 3.06117 \cr
Total Chol \tab 1.12370 \cr
HDL Chol \tab -0.93263 \cr
Sys BP \tab 1.93303 \cr
Sys BP + Hypertension Meds \tab 2.99881 \cr
Smoker \tab .65451  \cr
Non-Smoker \tab 0 \cr
Diabetic \tab 0.57367  \cr
Not Diabetic \tab 0 \cr
Average Risk \tab 23.9802 \cr
Risk Period \tab 0.88936 \cr
}

\strong{The equation for calculating risk:}

\deqn{RiskFactors = (log(Age) * AgeFactor)
+ (log(TotalChol) * TotalCholFactor)
+ (log(CholHDL) * CholHDLFactor) \\
+ (log(SysBP) * SysBPFactor) + Smoker
+ Diabetes Present - AvgRisk}

\deqn{Risk = 100 * (1 - RiskPeriodFactor ^ exp(RiskFactors))}
}
\examples{
compute_framingham(
  sysbp = 133, chol = 216.16, cholhdl = 54.91, age = 53,
  sex = "M", smokefl = "N", diabetfl = "N", trthypfl = "N"
)

compute_framingham(
  sysbp = 161, chol = 186.39, cholhdl = 64.19, age = 52,
  sex = "F", smokefl = "Y", diabetfl = "N", trthypfl = "Y"
)
}
\seealso{
\code{\link[=derive_param_framingham]{derive_param_framingham()}}

BDS-Findings Functions that returns a vector: 
\code{\link{compute_bmi}()},
\code{\link{compute_bsa}()},
\code{\link{compute_egfr}()},
\code{\link{compute_map}()},
\code{\link{compute_qtc}()},
\code{\link{compute_qual_imputation}()},
\code{\link{compute_qual_imputation_dec}()},
\code{\link{compute_rr}()},
\code{\link{compute_scale}()},
\code{\link{transform_range}()}
}
\concept{com_bds_findings}
\keyword{com_bds_findings}
