% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eigenstrat.R
\name{eigenstrat}
\alias{eigenstrat}
\title{EIGENSTRAT data constructor}
\usage{
eigenstrat(prefix = NULL, ind = NULL, snp = NULL, geno = NULL, exclude = NULL)
}
\arguments{
\item{prefix}{Shared path to an EIGENSTRAT trio (set of ind/snp/geno files).}

\item{ind, snp, geno}{Paths to individual EIGENSTRAT components.}

\item{exclude}{Pre-defined snp file with excluded sites.}
}
\value{
S3 object of the EIGENSTRAT class.
}
\description{
This function creates an instance of the EIGENSTRAT S3 class, which
encapsulates all paths to data files required for an ADMIXTOOLS analysis.
}
\examples{
\dontrun{# download an example genomic data and get the path prefix to the
# trio of snp/geno/ind files in an EIGENSTRAT format
prefix <- download_data(dirname = tempdir())

# wrap the trio of snp/geno/ind files in an object of the class
# EIGENSTRAT
snps <- eigenstrat(prefix)
}

}
