% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/propose.R
\docType{data}
\name{seven_leaves_graphs}
\alias{seven_leaves_graphs}
\title{Seven leaves graphs.}
\format{A list of functions on seven leaves and a parameter \code{permutations} which
        is \code{FALSE} by default.
        The outputs of these functions are either single \code{\link{agraph}} objects
        with the input vector as leaves, or if \code{permutations} is \code{TRUE},
        lists of all the possible \code{\link{agraph}} objects with that leaf set up
        to symmetry.}
\usage{
seven_leaves_graphs
}
\description{
Kind of obsolete since the introduction of \code{\link{all_graphs}}.
A comprehensive listing of all the \eqn{48} admixture graphs with seven leaves and
at most one admixture event. Our convention is that the position of the root does
not matter (as long as it's not after an admixture event) and that graphs that have
\emph{eyes}, two inner nodes with the property that all the paths between any two
leaves visits both or neither of them, are excluded. The reason  is that the \eqn{f}
statistics can't detect the exact position of the root or distinguish between an
eye and a simple branch. The position of the root can be moved later with the function
\code{\link{make_an_outgroup}}.
}
\examples{
\donttest{
# While the usage of this function is pretty self-explanatory, let's plot all the graphs
# just for browsing.
for (i in seq(1, length(seven_leaves_graphs))) {
  graph <- seven_leaves_graphs[[i]](c("A", "B", "C", "D", "E", "F", "G"))
  # This is how you include quotation marks in strings by the way:
  title <- paste("seven_leaves_graphs[[", i,
                 "]](c(\\"A\\", \\"B\\", \\"C\\", \\"D\\", \\"E\\", \\"F\\", \\"G\\"))", sep = "")
  plot(graph, color = "seagreen", title = title)
}
}

}
\seealso{
\code{\link{all_graphs}}

\code{\link{make_permutations}}

\code{\link{fit_permutations_and_graphs}}

\code{\link{fit_graph_list}}

\code{\link{add_a_leaf}}

\code{\link{add_an_admixture}}

\code{\link{add_an_admixture2}}

\code{\link{make_an_outgroup}}

Other graphs: \code{\link{eight_leaves_trees}},
  \code{\link{five_leaves_graphs}},
  \code{\link{four_leaves_graphs}},
  \code{\link{six_leaves_graphs}}
}
\keyword{datasets}

