% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_usage.R
\name{get_usage_logs}
\alias{get_usage_logs}
\title{Get a list of user usage}
\usage{
get_usage_logs(
  startDate = Sys.Date() - 91,
  endDate = Sys.Date() - 1,
  login = NULL,
  ip = NULL,
  rsid = NULL,
  eventType = NULL,
  event = NULL,
  limit = 100,
  page = 0,
  company_id = Sys.getenv("AW_COMPANY_ID")
)
}
\arguments{
\item{startDate}{Start date for the maximum of a 3 month period.}

\item{endDate}{End date for the maximum of a 3 month period.}

\item{login}{The login value of the user you want to filter logs by.}

\item{ip}{The IP address you want to filter logs by.}

\item{rsid}{The report suite ID you want to filter logs by.}

\item{eventType}{The numeric id for the event type you want to filter logs by. Leaving this blank returns
all events. See the \href{https://github.com/AdobeDocs/analytics-2.0-apis/blob/master/usage-logs.md}{Usage Logs API Guide}
for a complete list of event types.}

\item{event}{The event description you want to filter logs by. No wildcards are permitted.}

\item{limit}{The number of results to return per page. This argument works in conjunction with the
\code{page} argument. The default is 10.}

\item{page}{The "page" of results to display. This works in conjunction with the \code{limit} argument and is
zero-based. For instance, if \code{limit = 20} and \code{page = 1}, the results returned would be 21 through 40.}

\item{company_id}{Company ID. If an environment variable called \code{AW_COMPANY_ID} exists in \code{.Renviron} or
elsewhere and no \code{company_id} argument is provided, then the \code{AW_COMPANY_ID} value will be used.
Use \code{\link{get_me}} to get a list of available \code{company_id} values.}
}
\value{
A data frame of logged events and the event meta data.
}
\description{
This function returns the usage and access logs for a given date range within a 3 month period.
The user must have Admin Console / Logs permissions (must be able to view the \strong{Usage & Access Log}
data in the web interface) in order to use this function.
}
\examples{
\dontrun{
get_usage_logs(startDate = Sys.Date()-91, endDate = Sys.Date()-1, limit = 100, page = 0)
}

}
