% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cm_update.R
\name{cm_update}
\alias{cm_update}
\title{Update Calculated Metric Functions}
\usage{
cm_update(
  id = NULL,
  updates = NULL,
  locale = "en_US",
  debug = FALSE,
  company_id = Sys.getenv("AW_COMPANY_ID")
)
}
\arguments{
\item{id}{Returns details around a single calculated metric function if you specify the id.
You can obtain the desired id by not including an ID value and finding the function in the results.}

\item{updates}{List of changes or entire JSON definition object.}

\item{locale}{All calculated metrics endpoints support the URL query parameter locale.
Supported values are en_US, fr_FR, ja_JP, de_DE, es_ES, ko_KR, pt_BR, zh_CN, and zh_TW.
This argument specifies which language is to be used for localized sections of responses.}

\item{debug}{Set to \code{TRUE} to publish the full JSON request(s) being sent to the API to the console when the
function is called. The default is \code{FALSE}.}

\item{company_id}{Company ID. If an environment variable called \code{AW_COMPANY_ID} exists in \code{.Renviron} or
elsewhere and no \code{company_id} argument is provided, then the \code{AW_COMPANY_ID} value will be used.
Use \code{\link[=get_me]{get_me()}} to get a list of available \code{company_id} values.}
}
\value{
Returns a json string of information about the updated calculated metric
}
\description{
Update a specific calculated metric.
}
