% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FDistribution.R
\docType{class}
\name{NestedModels-class}
\alias{NestedModels-class}
\alias{NestedModels}
\alias{quantile,NestedModels-method}
\alias{simulate,NestedModels,numeric-method}
\title{F-Distribution}
\usage{
NestedModels(p_inner, p_outer)

\S4method{quantile}{NestedModels}(x, probs, n, theta, ...)

\S4method{simulate}{NestedModels,numeric}(object, nsim, n, theta, seed = NULL, ...)
}
\arguments{
\item{p_inner}{number of independent variables in smaller model}

\item{p_outer}{number of independent variables in bigger model}

\item{x}{outcome}

\item{probs}{vector of probabilities}

\item{n}{sample size}

\item{theta}{distribution parameter}

\item{...}{further optional arguments}

\item{object}{object of class \code{NestedModels}}

\item{nsim}{number of simulation runs}

\item{seed}{random seed}
}
\description{
Implements the F-distribution used for an ANOVA or for the comparison of the fit of two
nested regression models. In both cases, the test statistic follows a F-distribution.
\code{NestedModel} is used to compare the fit of two regression models, where one model contains
the independent variables of the smaller model as a subset. Then, one can use ANOVA to determine
whether more variance can be explained by adding more independent variables.
In the class \code{ANOVA}, the number of independent variables of the smaller model is set to \eqn{1}
in order to match the degrees of freedom and we obtain a one-way ANOVA.
}
\section{Slots}{

\describe{
\item{\code{p_inner}}{number of parameters in smaller model}

\item{\code{p_outer}}{number of parameters in bigger model}
}}

\examples{
model <- NestedModels(2, 4)

}
\seealso{
See \code{\link{probability_density_function}} and
\code{\link{cumulative_distribution_function}} to evaluate the pdf
and the cdf, respectively. Use \code{\link{ANOVA}} for detailed information
of ANOVA.
}
