% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generic-s3.R
\name{print.aggTrees.inference}
\alias{print.aggTrees.inference}
\title{Print Method for aggTrees.inference Objects}
\usage{
\method{print}{aggTrees.inference}(x, table = "avg_char", ...)
}
\arguments{
\item{x}{\code{aggTrees.inference} object.}

\item{table}{Either \code{"avg_char"} or \code{"diff"}, controls which table must be produced.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
Prints LATEX code.
}
\description{
Prints an \code{aggTrees.inference} object.
}
\details{
A description of each table is provided in its caption.\cr

Some covariates may feature zero variation in some leaf. This generally happens to dummy variables used to split some
nodes. In this case, when \code{table == "avg_char"} a warning message is produced displaying the names of the covariates
with zero variation in one or more leaves. The user should correct the table by removing the associated standard errors.\cr

Compilation of the LATEX code requires the following packages: \code{booktabs}, \code{float}, \code{adjustbox},
\code{multirow}.
}
\examples{
\donttest{
## Generate data.
set.seed(1986)

n <- 1000
k <- 3

X <- matrix(rnorm(n * k), ncol = k)
colnames(X) <- paste0("x", seq_len(k))
D <- rbinom(n, size = 1, prob = 0.5)
mu0 <- 0.5 * X[, 1]
mu1 <- 0.5 * X[, 1] + X[, 2]
y <- mu0 + D * (mu1 - mu0) + rnorm(n)

## Construct sequence of groupings. CATEs estimated internally,
groupings <- build_aggtree(y, D, X, method = "aipw")

## Analyze results with 4 groups.
results <- inference_aggtree(groupings, n_groups = 4)

## Print results.
print(results, table = "diff")
print(results, table = "avg_char")}

}
\references{
\itemize{
  \item R Di Francesco (2022). Aggregation Trees. CEIS Research Paper, 546. \doi{10.2139/ssrn.4304256}.
}
}
\seealso{
\code{\link{build_aggtree}}, \code{\link{inference_aggtree}}
}
\author{
Riccardo Di Francesco
}
