% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gst.R
\name{gst}
\alias{gst}
\title{Growing Season Temperature (GST)}
\usage{
gst(mx, mn, lati, dates)
}
\arguments{
\item{mx}{vector of daily maximum temperature series.}

\item{mn}{vector of daily minimum temperature series.}

\item{lati}{numeric value indicating the latitude of location.}

\item{dates}{vector of dates corresponding with daily temprature series}
}
\value{
A numeric vector with annual values is returned.
}
\description{
Growing Season Temperature (GST). Mean daily temperature in growing season.
}
\details{
Depending on the latitude, the function detects the hemisphere and considers growing season from 1st April to 31st October (northern hemisphere) or from 1st October to 30rd April (southern hemisphere).
}
\examples{

  gst(mx = daily_tmax,
    mn = daily_tmin,
    dates = seq.Date(as.Date('1981-01-01'),
            as.Date('2010-12-31'), by ='day'),
            lati = 42)

}
\references{
Jones G, Duff A, Hall A, Myers J (2010) Spatial Analysis of Climate in Winegrape Growing Regions in the Western United States. Am. J. Enol. Vitic. 61:3.
}
