% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ability_agreement.R
\name{compute_stats_agreement}
\alias{compute_stats_agreement}
\title{Agreement of Human and AI Decision Makers}
\usage{
compute_stats_agreement(Y, D, Z, A, X = NULL)
}
\arguments{
\item{Y}{An observed outcome (binary: numeric vector of 0 or 1).}

\item{D}{An observed decision (binary: numeric vector of 0 or 1).}

\item{Z}{A treatment indicator (binary: numeric vector of 0 or 1).}

\item{A}{An AI recommendation (binary: numeric vector of 0 or 1).}

\item{X}{Pretreatment covariate used for subgroup analysis (vector). Must be the same length as Y, D, Z, and A if provided. Default is NULL.}
}
\value{
A tibble with the following columns:
\itemize{
  \item \code{X}: Pretreatment covariate (if provided).
  \item \code{agree_diff}: Difference in agreement between human decisions and AI recommendations.
  \item \code{agree_diff_se}: Standard error of the difference in agreement.
}
}
\description{
Estimate the impact of AI recommendations on the agreement between human decisions and AI recommendations using a difference-in-means estimator of an indicator \eqn{1\{D_i = A_i\}}.
}
\examples{
compute_stats_agreement(
  Y = NCAdata$Y,
  D = ifelse(NCAdata$D == 0, 0, 1),
  Z = NCAdata$Z,
  A = PSAdata$DMF
)

}
